/*
 * Decompiled with CFR 0.152.
 */
package org.naviqore.gtfs.schedule;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

interface DataProvider {
    public File getZip(Path var1, String var2) throws IOException;

    default public File getUnzipped(Path dir, String name) throws IOException {
        File zipFile = this.getZip(dir, name);
        Path unzipTarget = dir.resolve(name);
        this.unzip(zipFile.toPath(), unzipTarget);
        return unzipTarget.toFile();
    }

    default public void unzip(Path zipFilePath, Path targetDir) throws IOException {
        Files.createDirectories(targetDir, new FileAttribute[0]);
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(zipFilePath, new OpenOption[0]));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                Path entryPath = targetDir.resolve(entry.getName()).normalize();
                if (!entryPath.startsWith(targetDir)) {
                    throw new IOException("Invalid zip entry: " + entry.getName());
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    try (OutputStream os = Files.newOutputStream(entryPath, new OpenOption[0]);){
                        zis.transferTo(os);
                    }
                }
                zis.closeEntry();
            }
        }
    }
}

