/*
 * Decompiled with CFR 0.152.
 */
package org.naviqore.gtfs.schedule;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.naviqore.gtfs.schedule.DataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalProvider
implements DataProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalProvider.class);
    private final String resourcePath;

    public LocalProvider(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public File getZip(Path dir, String name) throws IOException {
        log.info("Loading local dataset: {}", (Object)this.resourcePath);
        Files.createDirectories(dir, new FileAttribute[0]);
        Path zipPath = dir.resolve(name + ".zip");
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.resourcePath);){
            if (is == null) {
                throw new FileNotFoundException("Resource not found: " + this.resourcePath);
            }
            Files.copy(is, zipPath, StandardCopyOption.REPLACE_EXISTING);
            log.debug("Copied local resource to: {}", (Object)zipPath);
        }
        return zipPath.toFile();
    }
}

