/*
 * Decompiled with CFR 0.152.
 */
package org.naviqore.utils.search;

import lombok.Generated;
import org.naviqore.utils.search.CompressedTrie;
import org.naviqore.utils.search.SearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchIndexBuilder<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchIndexBuilder.class);
    private final CompressedTrie<SearchIndex.Entry<T>> suffixTrie = new CompressedTrie();
    private int count;

    public SearchIndexBuilder<T> add(String key, T value) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty.");
        }
        log.debug("Adding search key: {}", (Object)key);
        SearchIndex.Entry<T> entry = new SearchIndex.Entry<T>(key, value);
        for (int i = key.length() - 1; i >= 0; --i) {
            this.suffixTrie.insert(key.substring(i), entry);
        }
        ++this.count;
        return this;
    }

    public SearchIndex<T> build() {
        log.info("Building search index for {} entries (compressed suffix trie, keys: {} nodes: {})", new Object[]{this.count, this.suffixTrie.size(), this.suffixTrie.getNodes().size()});
        this.suffixTrie.trimToSize();
        return new SearchIndex<T>(this.suffixTrie);
    }
}

