/*
 * Decompiled with CFR 0.152.
 */
package org.naviqore.utils.spatial;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.jetbrains.annotations.NotNull;
import org.naviqore.utils.spatial.Coordinate;

public record GeoCoordinate(double latitude, double longitude) implements Coordinate,
Comparable<GeoCoordinate>
{
    private static final int EARTH_RADIUS = 6371000;

    public GeoCoordinate {
        GeoCoordinate.validateCoordinate(latitude, longitude);
    }

    private static void validateCoordinate(double latitude, double longitude) {
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("Latitude must be between -90 and 90 degrees");
        }
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("Longitude must be between -180 and 180 degrees");
        }
        if (Double.isNaN(latitude) || Double.isNaN(longitude)) {
            throw new IllegalArgumentException("Coordinates cannot be NaN");
        }
    }

    private void isOfSameType(Coordinate other) {
        if (other == null) {
            throw new IllegalArgumentException("Other coordinate must not be null");
        }
        if (other.getClass() != this.getClass()) {
            throw new IllegalArgumentException("Other coordinate must be of type " + this.getClass().getSimpleName());
        }
    }

    @Override
    @JsonIgnore
    public double getFirstComponent() {
        return this.latitude;
    }

    @Override
    @JsonIgnore
    public double getSecondComponent() {
        return this.longitude;
    }

    @Override
    public double distanceTo(Coordinate other) {
        this.isOfSameType(other);
        return this.distanceTo(other.getFirstComponent(), other.getSecondComponent());
    }

    @Override
    public double distanceTo(double firstComponent, double secondComponent) {
        GeoCoordinate.validateCoordinate(firstComponent, secondComponent);
        double lat1 = Math.toRadians(this.latitude);
        double lat2 = Math.toRadians(firstComponent);
        double lon1 = Math.toRadians(this.longitude);
        double lon2 = Math.toRadians(secondComponent);
        double dLat = lat2 - lat1;
        double dLon = lon2 - lon1;
        double a = Math.pow(Math.sin(dLat / 2.0), 2.0) + Math.pow(Math.sin(dLon / 2.0), 2.0) * Math.cos(lat1) * Math.cos(lat2);
        double c = 2.0 * Math.asin(Math.sqrt(a));
        return 6371000.0 * c;
    }

    @Override
    public int compareTo(GeoCoordinate other) {
        double epsilon = 1.0E-5;
        double diffLatitude = this.latitude - other.latitude();
        if (Math.abs(diffLatitude) > epsilon) {
            return diffLatitude > 0.0 ? 1 : -1;
        }
        double diffLongitude = this.longitude - other.longitude();
        if (Math.abs(diffLongitude) > epsilon) {
            return diffLongitude > 0.0 ? 1 : -1;
        }
        return 0;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(lat=" + this.latitude + "\u00b0, lon=" + this.longitude + "\u00b0)";
    }
}

