/*
 * Decompiled with CFR 0.152.
 */
package org.naviqore.utils.spatial.index;

import java.util.ArrayList;
import lombok.Generated;
import org.naviqore.utils.spatial.Coordinate;
import org.naviqore.utils.spatial.Location;

public class KDTree<T extends Location<?>> {
    private static final int K_DIMENSIONS = 2;
    Node<T> root;

    static Coordinate.Axis getAxis(int depth) {
        return depth % 2 == 0 ? Coordinate.Axis.FIRST : Coordinate.Axis.SECOND;
    }

    private static <T extends Location<?>> Node<T> getNextNodeBasedOnAxisDirection(Node<T> node, InternalCoordinate coordinate, Coordinate.Axis axis) {
        Object nodeCoordinate = ((Location)node.location).getCoordinate();
        return coordinate.getComponent(axis) < nodeCoordinate.getComponent(axis) ? node.left : node.right;
    }

    private static <T extends Location<?>> boolean isDistanceGreaterThanCoordinateDifference(Node<T> node, InternalCoordinate coordinate, Coordinate.Axis axis) {
        double coordinateDifference;
        Object nodeCoordinate = ((Location)node.location).getCoordinate();
        double distance = nodeCoordinate.distanceTo(coordinate.firstComponent(), coordinate.secondComponent());
        return distance > (coordinateDifference = Math.abs(coordinate.getComponent(axis) - nodeCoordinate.getComponent(axis)));
    }

    void insert(T location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        int startDepth = 0;
        this.root = this.insert(this.root, location, startDepth);
    }

    private Node<T> insert(Node<T> node, T location, int depth) {
        if (node == null) {
            return new Node<T>(location);
        }
        Coordinate.Axis axis = KDTree.getAxis(depth);
        if (location.getCoordinate().getComponent(axis) < ((Location)node.location).getCoordinate().getComponent(axis)) {
            node.left = this.insert(node.left, location, depth + 1);
        } else {
            node.right = this.insert(node.right, location, depth + 1);
        }
        return node;
    }

    public T nearestNeighbour(T location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        return this.nearestNeighbour((Coordinate)location.getCoordinate());
    }

    public T nearestNeighbour(Coordinate coordinate) {
        if (coordinate == null) {
            throw new IllegalArgumentException("Coordinate cannot be null");
        }
        return this.nearestNeighbour(coordinate.getFirstComponent(), coordinate.getSecondComponent());
    }

    public T nearestNeighbour(double firstComponent, double secondComponent) {
        if (this.root == null) {
            throw new IllegalStateException("Tree is empty");
        }
        return (T)((Location)this.nearestNeighbour(this.root, (InternalCoordinate)new InternalCoordinate((double)firstComponent, (double)secondComponent), (int)0).location);
    }

    private Node<T> nearestNeighbour(Node<T> node, InternalCoordinate coordinate, int depth) {
        if (node == null) {
            return null;
        }
        Coordinate.Axis axis = KDTree.getAxis(depth);
        Node<T> next = KDTree.getNextNodeBasedOnAxisDirection(node, coordinate, axis);
        Node other = next == node.left ? node.right : node.left;
        Node<T> best = this.getNodeWithClosestDistance(node, this.nearestNeighbour(next, coordinate, depth + 1), coordinate);
        if (KDTree.isDistanceGreaterThanCoordinateDifference(node, coordinate, axis)) {
            best = this.getNodeWithClosestDistance(best, this.nearestNeighbour(other, coordinate, depth + 1), coordinate);
        }
        return best;
    }

    private Node<T> getNodeWithClosestDistance(Node<T> node1, Node<T> node2, InternalCoordinate coordinate) {
        double dist2;
        if (node1 == null) {
            return node2;
        }
        if (node2 == null) {
            return node1;
        }
        double dist1 = ((Location)node1.location).getCoordinate().distanceTo(coordinate.firstComponent(), coordinate.secondComponent());
        return dist1 < (dist2 = ((Location)node2.location).getCoordinate().distanceTo(coordinate.firstComponent(), coordinate.secondComponent())) ? node1 : node2;
    }

    public ArrayList<T> rangeSearch(T center, double radius) {
        if (center == null) {
            throw new IllegalArgumentException("Center location cannot be null");
        }
        return this.rangeSearch((Coordinate)center.getCoordinate(), radius);
    }

    public ArrayList<T> rangeSearch(Coordinate center, double radius) {
        if (center == null) {
            throw new IllegalArgumentException("Center coordinate cannot be null");
        }
        return this.rangeSearch(center.getFirstComponent(), center.getSecondComponent(), radius);
    }

    public ArrayList<T> rangeSearch(double firstComponent, double secondComponent, double radius) {
        if (this.root == null) {
            throw new IllegalStateException("Tree is empty");
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius cannot be negative or zero");
        }
        ArrayList result = new ArrayList();
        this.rangeSearch(this.root, new InternalCoordinate(firstComponent, secondComponent), radius, 0, result);
        return result;
    }

    private void rangeSearch(Node<T> node, InternalCoordinate coordinate, double radius, int depth, ArrayList<T> result) {
        double nodeCoordinateOfInterest;
        Coordinate.Axis axis;
        double centerCoordinateOfInterest;
        if (node == null) {
            return;
        }
        double distance = ((Location)node.location).getCoordinate().distanceTo(coordinate.firstComponent(), coordinate.secondComponent());
        if (distance <= radius) {
            result.add((Location)node.location);
        }
        if ((centerCoordinateOfInterest = coordinate.getComponent(axis = KDTree.getAxis(depth))) - radius < (nodeCoordinateOfInterest = ((Location)node.location).getCoordinate().getComponent(axis))) {
            this.rangeSearch(node.left, coordinate, radius, depth + 1, result);
        }
        if (centerCoordinateOfInterest + radius >= nodeCoordinateOfInterest) {
            this.rangeSearch(node.right, coordinate, radius, depth + 1, result);
        }
    }

    @Generated
    KDTree() {
    }

    static class Node<U> {
        private final U location;
        private Node<U> left;
        private Node<U> right;

        @Generated
        public U getLocation() {
            return this.location;
        }

        @Generated
        public Node<U> getLeft() {
            return this.left;
        }

        @Generated
        public Node<U> getRight() {
            return this.right;
        }

        @Generated
        Node(U location) {
            this.location = location;
        }
    }

    private record InternalCoordinate(double firstComponent, double secondComponent) {
        private double getComponent(Coordinate.Axis axis) {
            return axis == Coordinate.Axis.FIRST ? this.firstComponent : this.secondComponent;
        }
    }
}

