/*
 * Decompiled with CFR 0.152.
 */
package org.naviqore.utils.spatial.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.naviqore.utils.spatial.Coordinate;
import org.naviqore.utils.spatial.Location;
import org.naviqore.utils.spatial.index.KDTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDTreeBuilder<T extends Location<?>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KDTreeBuilder.class);
    private ArrayList<T> locations = new ArrayList();

    public KDTreeBuilder<T> addLocation(T location) {
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null");
        }
        this.locations.add(location);
        return this;
    }

    public KDTreeBuilder<T> addLocations(Collection<T> locations) {
        if (locations == null) {
            throw new IllegalArgumentException("locations must not be null");
        }
        for (Location location : locations) {
            this.addLocation(location);
        }
        return this;
    }

    public KDTree<T> build() {
        if (this.locations == null || this.locations.isEmpty()) {
            throw new IllegalArgumentException("locations must not be null or empty");
        }
        log.info("Building spatial index for {} locations", (Object)this.locations.size());
        KDTree tree = new KDTree();
        this.locations = new ArrayList<T>(this.balanceSortLocations(this.locations, 0));
        this.locations.forEach(tree::insert);
        return tree;
    }

    List<T> balanceSortLocations(Collection<T> locations, int depth) {
        if (locations.size() <= 1) {
            return new ArrayList<T>(locations.stream().toList());
        }
        Coordinate.Axis axis = KDTree.getAxis(depth);
        List<T> sortedLocations = locations.stream().sorted((l1, l2) -> {
            double c1 = l1.getCoordinate().getComponent(axis);
            double c2 = l2.getCoordinate().getComponent(axis);
            return Double.compare(c1, c2);
        }).toList();
        int medianIndex = sortedLocations.size() / 2;
        ArrayList balancedList = new ArrayList();
        balancedList.add((Location)sortedLocations.get(medianIndex));
        balancedList.addAll(this.balanceSortLocations(sortedLocations.subList(0, medianIndex), depth + 1));
        balancedList.addAll(this.balanceSortLocations(sortedLocations.subList(medianIndex + 1, sortedLocations.size()), depth + 1));
        return balancedList;
    }

    @Generated
    public KDTreeBuilder() {
    }
}

