/*
 * Decompiled with CFR 0.152.
 */
package org.naviqore.utils.cache;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvictionCache<K, V> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EvictionCache.class);
    private final int size;
    private final Strategy strategy;
    private final Map<K, V> cache;
    private final LinkedHashMap<K, Long> accessOrder;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public EvictionCache(int size, Strategy strategy) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be greater than 0.");
        }
        this.size = size;
        this.strategy = strategy;
        this.cache = new HashMap();
        this.accessOrder = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V computeIfAbsent(K key, Supplier<V> supplier) {
        this.readLock.lock();
        try {
            if (this.cache.containsKey(key)) {
                V v = this.retrieveFromCache(key);
                return v;
            }
        }
        finally {
            this.readLock.unlock();
        }
        V value = supplier.get();
        this.writeLock.lock();
        try {
            if (this.cache.containsKey(key)) {
                V v = this.retrieveFromCache(key);
                return v;
            }
            if (this.cache.size() >= this.size) {
                this.evict();
            }
            log.debug("No cache hit, setting new instance for key {}", key);
            this.cache.put(key, value);
            this.updateAccessOrder(key);
            V v = value;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
            this.accessOrder.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isCached(K key) {
        this.readLock.lock();
        try {
            boolean bl = this.cache.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getNumberOfEntries() {
        this.readLock.lock();
        try {
            int n = this.cache.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private V retrieveFromCache(K key) {
        log.debug("Cache hit, retrieving cached instance for key {}", key);
        this.updateAccessOrder(key);
        return this.cache.get(key);
    }

    private void updateAccessOrder(K key) {
        this.accessOrder.put(key, System.nanoTime());
    }

    private void evict() {
        K keyToEvict;
        K k = keyToEvict = this.strategy == Strategy.LRU ? this.findLRUKey() : this.findMRUKey();
        if (keyToEvict != null) {
            log.debug("Removing cached key {}, last access at {}", keyToEvict, (Object)this.accessOrder.get(keyToEvict));
            this.cache.remove(keyToEvict);
            this.accessOrder.remove(keyToEvict);
        }
    }

    private K findLRUKey() {
        return this.accessOrder.entrySet().stream().min(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
    }

    private K findMRUKey() {
        return this.accessOrder.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    public static enum Strategy {
        LRU,
        MRU;

    }
}

