/*
 * Decompiled with CFR 0.152.
 */
package org.naviqore.utils.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.naviqore.utils.search.Trie;

public class CompressedTrie<T>
implements Trie<T> {
    private final Node<T> root = new Node<Object>(null, "");
    private int size;

    @Override
    public void insert(String key, T value) {
        int commonLength;
        ++this.size;
        Node<T> currentNode = this.root;
        for (int index = 0; index < key.length(); index += commonLength) {
            String segment = key.substring(index);
            Node<T> child = currentNode.getChildStartingWith(segment);
            if (child == null) {
                Node<T> newNode = new Node<T>(value, segment);
                currentNode.addChild(newNode);
                return;
            }
            commonLength = child.getCommonPrefixLength(segment);
            if (commonLength < child.segment.length()) {
                child.split(commonLength);
            }
            if (commonLength < segment.length()) {
                currentNode = child;
                continue;
            }
            child.addValue(value);
            return;
        }
    }

    @Override
    public List<T> startsWith(String prefix) {
        int segmentLength;
        Node<Object> currentNode = this.root;
        ArrayList results = new ArrayList();
        for (int index = 0; index < prefix.length(); index += segmentLength) {
            char currentChar = prefix.charAt(index);
            Node nextNode = currentNode.children.get(Character.valueOf(currentChar));
            if (nextNode == null) {
                return results;
            }
            String segment = nextNode.segment;
            segmentLength = segment.length();
            int prefixRemaining = prefix.length() - index;
            int compareLength = Math.min(segmentLength, prefixRemaining);
            for (int i = 0; i < compareLength; ++i) {
                if (segment.charAt(i) == prefix.charAt(index + i)) continue;
                return results;
            }
            if (compareLength == segmentLength && segmentLength < prefixRemaining) {
                currentNode = nextNode;
                continue;
            }
            nextNode.collectAllValues(results);
            return results;
        }
        if (prefix.isEmpty()) {
            currentNode.collectAllValues(results);
        }
        return results;
    }

    @Override
    public List<Trie.Node<T>> getNodes() {
        ArrayList nodes = new ArrayList();
        this.root.collectNodes(nodes);
        return new ArrayList<Trie.Node<T>>(nodes);
    }

    @Override
    public int size() {
        return this.size;
    }

    public void trimToSize() {
        ArrayList nodes = new ArrayList();
        this.root.collectNodes(nodes);
        for (Node node : nodes) {
            ((ArrayList)node.values).trimToSize();
        }
    }

    private static class Node<V>
    implements Trie.Node<V> {
        private Map<Character, Node<V>> children = new HashMap<Character, Node<V>>();
        private List<V> values = new ArrayList<V>();
        private String segment;

        Node(V value, String segment) {
            if (value != null) {
                this.values.add(value);
            }
            this.segment = segment;
        }

        void addChild(Node<V> child) {
            this.children.put(Character.valueOf(child.segment.charAt(0)), child);
        }

        Node<V> getChildStartingWith(String segment) {
            return this.children.get(Character.valueOf(segment.charAt(0)));
        }

        void addValue(V value) {
            this.values.add(value);
        }

        int getCommonPrefixLength(String other) {
            int minLength = Math.min(this.segment.length(), other.length());
            for (int i = 0; i < minLength; ++i) {
                if (this.segment.charAt(i) == other.charAt(i)) continue;
                return i;
            }
            return minLength;
        }

        void split(int index) {
            String newSegment = this.segment.substring(index);
            this.segment = this.segment.substring(0, index);
            Node<Object> newNode = new Node<Object>(null, newSegment);
            newNode.children = this.children;
            newNode.values = this.values;
            this.children = new HashMap<Character, Node<V>>();
            this.values = new ArrayList<V>();
            this.addChild(newNode);
        }

        void collectAllValues(List<V> results) {
            results.addAll(this.values);
            for (Node<V> child : this.children.values()) {
                child.collectAllValues(results);
            }
        }

        void collectNodes(List<Node<V>> nodes) {
            nodes.add(this);
            for (Node<V> child : this.children.values()) {
                child.collectNodes(nodes);
            }
        }

        @Override
        public List<Trie.Node<V>> getChildren() {
            return new ArrayList<Trie.Node<V>>(this.children.values());
        }

        @Override
        public List<V> getValues() {
            return new ArrayList<V>(this.values);
        }

        @Generated
        public String toString() {
            return "CompressedTrie.Node(children=" + String.valueOf(this.getChildren()) + ", values=" + String.valueOf(this.getValues()) + ", segment=" + this.segment + ")";
        }
    }
}

