/*
 * Decompiled with CFR 0.152.
 */
package org.naviqore.utils.network;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileDownloader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileDownloader.class);
    private final HttpClient httpClient;
    private final URI url;

    public FileDownloader(String url) {
        this(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build(), URI.create(url));
    }

    FileDownloader(HttpClient httpClient, URI url) {
        this.httpClient = httpClient;
        this.url = url;
    }

    public void downloadTo(Path directory, String fileName, boolean overwrite) throws IOException, InterruptedException {
        this.ensureDirectory(directory);
        Path filePath = directory.resolve(fileName);
        if (this.shouldDownload(filePath, overwrite)) {
            this.downloadFile(filePath, overwrite);
        } else {
            log.debug("Dataset already exists: {}", (Object)filePath);
        }
    }

    private boolean shouldDownload(Path filePath, boolean overwrite) {
        return Files.notExists(filePath, new LinkOption[0]) || overwrite;
    }

    private void downloadFile(Path filePath, boolean overwrite) throws IOException, InterruptedException {
        if (Files.exists(filePath, new LinkOption[0]) && overwrite) {
            log.info("Overwriting existing file: {}", (Object)filePath);
            Files.delete(filePath);
        }
        log.info("Downloading file: {}", (Object)this.url);
        HttpRequest request = HttpRequest.newBuilder().uri(this.url).build();
        HttpResponse<Path> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofFile(filePath));
        if (response.statusCode() == 200) {
            log.info("Dataset downloaded successfully to: {}", (Object)filePath);
        } else {
            log.error("Download failed, HTTP status code: {}", (Object)response.statusCode());
            Files.deleteIfExists(filePath);
        }
    }

    private void ensureDirectory(Path directory) throws IOException {
        if (Files.notExists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
            log.info("Directory created: {}", (Object)directory);
        }
    }
}

