/*
 * Decompiled with CFR 0.152.
 */
package org.naviqore.utils.search;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.naviqore.utils.search.SearchIndexBuilder;
import org.naviqore.utils.search.Trie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchIndex<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchIndex.class);
    private final Trie<Entry<T>> suffixTrie;

    public static <T> SearchIndexBuilder<T> builder() {
        return new SearchIndexBuilder();
    }

    public Set<T> search(String query, SearchStrategy strategy) {
        log.debug("Searching for query: '{}' with strategy: {}", (Object)query, (Object)strategy);
        if (query == null || query.isEmpty()) {
            return Set.of();
        }
        List<Entry<T>> results = this.suffixTrie.startsWith(query);
        return switch (strategy.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> results.stream().filter(entry -> entry.key().equals(query)).map(Entry::value).collect(Collectors.toSet());
            case 0 -> results.stream().filter(entry -> entry.key().startsWith(query)).map(Entry::value).collect(Collectors.toSet());
            case 1 -> results.stream().filter(entry -> entry.key().endsWith(query)).map(Entry::value).collect(Collectors.toSet());
            case 2 -> results.stream().map(Entry::value).collect(Collectors.toSet());
        };
    }

    @Generated
    SearchIndex(Trie<Entry<T>> suffixTrie) {
        this.suffixTrie = suffixTrie;
    }

    public static enum SearchStrategy {
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS,
        EXACT;

    }

    record Entry<U>(String key, U value) {
    }
}

