/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.keyword;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ndviet.library.BrowserManagement;
import org.ndviet.library.TakeScreenshot;
import org.ndviet.library.TestObject.ObjectRepository;
import org.ndviet.library.TestObject.TestObject;
import org.ndviet.library.spring.SpringHelpers;
import org.openqa.selenium.WebElement;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.javalib.library.AnnotationLibrary;

@RobotKeywords
public class WebUI
extends AnnotationLibrary {
    public WebUI() {
        super(Arrays.asList("org/ndviet/keyword/WebUI.class"));
        SpringHelpers.getInstance().getBean("WebElementIdentifier");
    }

    @RobotKeyword
    @ArgumentNames(value={"fileName="})
    public void capturePageScreenshot(String fileName) throws Exception {
        TakeScreenshot.capturePageScreenshot((String)fileName);
    }

    @RobotKeywordOverload
    @ArgumentNames(value={})
    public void capturePageScreenshot() throws Exception {
        TakeScreenshot.capturePageScreenshot(null);
    }

    @RobotKeyword
    @ArgumentNames(value={"fileName="})
    public void captureFullPageScreenshot(String fileName) throws Exception {
        TakeScreenshot.captureFullPageScreenshot((String)fileName);
    }

    @RobotKeywordOverload
    @ArgumentNames(value={})
    public void captureFullPageScreenshot() throws Exception {
        TakeScreenshot.captureFullPageScreenshot(null);
    }

    @RobotKeyword
    public void openBrowser(String url) throws Exception {
        BrowserManagement.getInstance().openBrowser(url);
    }

    @RobotKeyword
    public void closeBrowser() {
        BrowserManagement.getInstance().closeBrowser();
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public WebElement findWebElement(String objectID, Map variables) throws Exception {
        return org.ndviet.library.WebUI.findWebElement((TestObject)ObjectRepository.findTestObject((String)objectID));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public WebElement findWebElement(String objectID) throws Exception {
        return org.ndviet.library.WebUI.findWebElement((TestObject)ObjectRepository.findTestObject((String)objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public List<WebElement> findWebElements(String objectID, Map variables) throws Exception {
        return org.ndviet.library.WebUI.findWebElements((TestObject)ObjectRepository.findTestObject((String)objectID, (Map)variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public List<WebElement> findWebElements(String objectID) throws Exception {
        return org.ndviet.library.WebUI.findWebElements((TestObject)ObjectRepository.findTestObject((String)objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void click(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.click((TestObject)ObjectRepository.findTestObject((String)objectID, (Map)variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void click(String objectID) throws Exception {
        org.ndviet.library.WebUI.click((TestObject)ObjectRepository.findTestObject((String)objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "absolutePath", "variables="})
    public void uploadFile(String objectID, String absolutePath, Map variables) throws Exception {
        org.ndviet.library.WebUI.uploadFile((TestObject)ObjectRepository.findTestObject((String)objectID, (Map)variables), (String)absolutePath);
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID", "absolutePath"})
    public void uploadFile(String objectID, String absolutePath) throws Exception {
        org.ndviet.library.WebUI.uploadFile((TestObject)ObjectRepository.findTestObject((String)objectID), (String)absolutePath);
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "text", "variables="})
    public void setText(String objectID, String text, Map variables) throws Exception {
        org.ndviet.library.WebUI.setText((TestObject)ObjectRepository.findTestObject((String)objectID, (Map)variables), (String)text);
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID", "text"})
    public void setText(String objectID, String text) throws Exception {
        org.ndviet.library.WebUI.setText((TestObject)ObjectRepository.findTestObject((String)objectID), (String)text);
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public String getText(String objectID, Map variables) throws Exception {
        return org.ndviet.library.WebUI.getText((TestObject)ObjectRepository.findTestObject((String)objectID, (Map)variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public String getText(String objectID) throws Exception {
        return org.ndviet.library.WebUI.getText((TestObject)ObjectRepository.findTestObject((String)objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID"})
    public List<String> getTexts(String objectID) throws Exception {
        return org.ndviet.library.WebUI.getTexts((TestObject)ObjectRepository.findTestObject((String)objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void verifyElementPresent(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.verifyElementPresent((TestObject)ObjectRepository.findTestObject((String)objectID, (Map)variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void verifyElementPresent(String objectID) throws Exception {
        org.ndviet.library.WebUI.verifyElementPresent((TestObject)ObjectRepository.findTestObject((String)objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void verifyElementNotPresent(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.verifyElementNotPresent((TestObject)ObjectRepository.findTestObject((String)objectID, (Map)variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void verifyElementNotPresent(String objectID) throws Exception {
        org.ndviet.library.WebUI.verifyElementNotPresent((TestObject)ObjectRepository.findTestObject((String)objectID));
    }

    @RobotKeyword
    public void verifyElementHasAttribute() {
    }

    @RobotKeyword
    public void verifyElementNotHasAttribute() {
    }

    @RobotKeyword
    public void verifyElementAttributeValue() {
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables", "expectValue="})
    public void verifyElementTextEquals(String objectID, Map variables, String expectText) throws Exception {
        org.ndviet.library.WebUI.verifyElementTextEquals((TestObject)ObjectRepository.findTestObject((String)objectID, (Map)variables), (String)expectText);
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID", "expectValue="})
    public void verifyElementTextEquals(String objectID, String expectText) throws Exception {
        org.ndviet.library.WebUI.verifyElementTextEquals((TestObject)ObjectRepository.findTestObject((String)objectID), (String)expectText);
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables", "expectValue="})
    public void verifyElementTextContains(String objectID, Map variables, String expectText) throws Exception {
        org.ndviet.library.WebUI.verifyElementTextContains((TestObject)ObjectRepository.findTestObject((String)objectID, (Map)variables), (String)expectText);
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID", "expectValue="})
    public void verifyElementTextContains(String objectID, String expectText) throws Exception {
        org.ndviet.library.WebUI.verifyElementTextContains((TestObject)ObjectRepository.findTestObject((String)objectID), (String)expectText);
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void verifyElementVisible(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.verifyElementVisible((TestObject)ObjectRepository.findTestObject((String)objectID, (Map)variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void verifyElementVisible(String objectID) throws Exception {
        org.ndviet.library.WebUI.verifyElementVisible((TestObject)ObjectRepository.findTestObject((String)objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void verifyElementNotVisible(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.verifyElementNotVisible((TestObject)ObjectRepository.findTestObject((String)objectID, (Map)variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void verifyElementNotVisible(String objectID) throws Exception {
        org.ndviet.library.WebUI.verifyElementNotVisible((TestObject)ObjectRepository.findTestObject((String)objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void moveToElement(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.moveToElement((TestObject)ObjectRepository.findTestObject((String)objectID, (Map)variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void moveToElement(String objectID) throws Exception {
        org.ndviet.library.WebUI.moveToElement((TestObject)ObjectRepository.findTestObject((String)objectID));
    }

    @RobotKeyword
    @ArgumentNames(value={"objectID", "variables="})
    public void scrollToElement(String objectID, Map variables) throws Exception {
        org.ndviet.library.WebUI.scrollToElement((TestObject)ObjectRepository.findTestObject((String)objectID, (Map)variables));
    }

    @RobotKeywordOverload
    @ArgumentNames(value={"objectID"})
    public void scrollToElement(String objectID) throws Exception {
        org.ndviet.library.WebUI.scrollToElement((TestObject)ObjectRepository.findTestObject((String)objectID));
    }
}

