/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StreamCorruptedException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.common.AbstractAgentProxy;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerHolder;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

public class AgentClient
extends AbstractAgentProxy
implements Runnable,
FactoryManagerHolder {
    public static final String MESSAGE_POLL_FREQUENCY = "agent-client-message-poll-time";
    public static final long DEFAULT_MESSAGE_POLL_FREQUENCY = TimeUnit.MINUTES.toMillis(2L);
    private final String authSocket;
    private final FactoryManager manager;
    private final long pool;
    private final long handle;
    private final Buffer receiveBuffer;
    private final Queue<Buffer> messages;
    private Future<?> pumper;
    private final AtomicBoolean open = new AtomicBoolean(true);

    public AgentClient(FactoryManager manager, String authSocket) throws IOException {
        this(manager, authSocket, null);
    }

    public AgentClient(FactoryManager manager, String authSocket, CloseableExecutorService executor) throws IOException {
        super(executor == null ? ThreadUtils.newSingleThreadExecutor("AgentClient[" + authSocket + "]") : executor);
        this.manager = Objects.requireNonNull(manager, "No factory manager instance provided");
        this.authSocket = authSocket;
        try {
            AprLibrary aprLibInstance = AprLibrary.getInstance();
            this.pool = Pool.create((long)aprLibInstance.getRootPool());
            this.handle = Local.create((String)authSocket, (long)this.pool);
            int result = Local.connect((long)this.handle, (long)0L);
            if (result != 0) {
                this.throwException(result);
            }
            this.receiveBuffer = new ByteArrayBuffer();
            this.messages = new ArrayBlockingQueue<Buffer>(10);
            CloseableExecutorService service = this.getExecutorService();
            this.pumper = service.submit(this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    @Override
    public FactoryManager getFactoryManager() {
        return this.manager;
    }

    public String getAuthSocket() {
        return this.authSocket;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block16: {
            byte[] buf = new byte[1024];
            while (this.isOpen()) {
                int result = Socket.recv((long)this.handle, (byte[])buf, (int)0, (int)buf.length);
                if (result < 0) {
                    this.throwException(result);
                }
                this.messageReceived(new ByteArrayBuffer(buf, 0, result));
            }
            try {
                this.close();
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("run({}) {} while closing: {}", this, e.getClass().getSimpleName(), e.getMessage());
                }
                break block16;
            }
            catch (Exception e) {
                block17: {
                    try {
                        boolean debugEnabled = this.log.isDebugEnabled();
                        if (this.isOpen()) {
                            this.log.warn("run({}) {} while still open: {}", this, e.getClass().getSimpleName(), e.getMessage());
                            if (debugEnabled) {
                                this.log.debug("run(" + this + ") open client exception", e);
                            }
                            break block17;
                        }
                        if (!debugEnabled) break block17;
                        this.log.debug("run(" + this + ") closed client loop exception", e);
                    }
                    catch (Throwable throwable) {
                        block18: {
                            try {
                                this.close();
                            }
                            catch (IOException e2) {
                                if (!this.log.isDebugEnabled()) break block18;
                                this.log.debug("run({}) {} while closing: {}", this, e2.getClass().getSimpleName(), e2.getMessage());
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    this.close();
                }
                catch (IOException e3) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("run({}) {} while closing: {}", this, e3.getClass().getSimpleName(), e3.getMessage());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void messageReceived(Buffer buffer) throws Exception {
        ByteArrayBuffer message = null;
        Object object = this.receiveBuffer;
        synchronized (object) {
            this.receiveBuffer.putBuffer(buffer);
            if (this.receiveBuffer.available() >= 4) {
                int rpos = this.receiveBuffer.rpos();
                int len = this.receiveBuffer.getInt();
                if (len < 0) {
                    throw new StreamCorruptedException("Illogical message length: " + len);
                }
                this.receiveBuffer.rpos(rpos);
                if (this.receiveBuffer.available() >= 4 + len) {
                    message = new ByteArrayBuffer(this.receiveBuffer.getBytes());
                    this.receiveBuffer.compact();
                }
            }
        }
        if (message != null) {
            object = this.messages;
            synchronized (object) {
                this.messages.offer(message);
                this.messages.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            Socket.close((long)this.handle);
        }
        Queue<Buffer> queue = this.messages;
        synchronized (queue) {
            this.messages.notifyAll();
        }
        if (this.pumper != null && !this.pumper.isDone()) {
            this.pumper.cancel(true);
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized Buffer request(Buffer buffer) throws IOException {
        int wpos = buffer.wpos();
        buffer.wpos(0);
        buffer.putUInt(wpos - 4);
        buffer.wpos(wpos);
        Queue<Buffer> queue = this.messages;
        synchronized (queue) {
            int result = Socket.send((long)this.handle, (byte[])buffer.array(), (int)buffer.rpos(), (int)buffer.available());
            if (result < 0) {
                this.throwException(result);
            }
            return this.waitForMessageBuffer();
        }
    }

    protected Buffer waitForMessageBuffer() throws IOException {
        FactoryManager mgr = this.getFactoryManager();
        long idleTimeout = PropertyResolverUtils.getLongProperty(mgr, MESSAGE_POLL_FREQUENCY, DEFAULT_MESSAGE_POLL_FREQUENCY);
        if (idleTimeout <= 0L) {
            idleTimeout = DEFAULT_MESSAGE_POLL_FREQUENCY;
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        int count = 1;
        while (true) {
            if (!this.isOpen()) {
                throw new SshException("Client is being closed");
            }
            if (!this.messages.isEmpty()) {
                return this.messages.poll();
            }
            if (traceEnabled) {
                this.log.trace("waitForMessageBuffer({}) wait iteration #{}", (Object)this, (Object)count);
            }
            try {
                this.messages.wait(idleTimeout);
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException("Interrupted while waiting for messages at iteration #" + count).initCause(e);
            }
            ++count;
        }
    }

    protected void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[socket=" + this.getAuthSocket() + "]";
    }
}

