/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v109.network.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v109.network.model.RequestId;
import org.openqa.selenium.devtools.v109.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class Initiator {
    private final Type type;
    private final Optional<StackTrace> stack;
    private final Optional<String> url;
    private final Optional<Number> lineNumber;
    private final Optional<Number> columnNumber;
    private final Optional<RequestId> requestId;

    public Initiator(Type type, Optional<StackTrace> stack, Optional<String> url, Optional<Number> lineNumber, Optional<Number> columnNumber, Optional<RequestId> requestId) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.stack = stack;
        this.url = url;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.requestId = requestId;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<StackTrace> getStack() {
        return this.stack;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<Number> getLineNumber() {
        return this.lineNumber;
    }

    public Optional<Number> getColumnNumber() {
        return this.columnNumber;
    }

    public Optional<RequestId> getRequestId() {
        return this.requestId;
    }

    private static Initiator fromJson(JsonInput input) {
        Type type = null;
        Optional<StackTrace> stack = Optional.empty();
        Optional<String> url = Optional.empty();
        Optional<Number> lineNumber = Optional.empty();
        Optional<Number> columnNumber = Optional.empty();
        Optional<RequestId> requestId = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block16;
                }
                case "stack": {
                    stack = Optional.ofNullable((StackTrace)input.read((java.lang.reflect.Type)((Object)StackTrace.class)));
                    continue block16;
                }
                case "url": {
                    url = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "lineNumber": {
                    lineNumber = Optional.ofNullable(input.nextNumber());
                    continue block16;
                }
                case "columnNumber": {
                    columnNumber = Optional.ofNullable(input.nextNumber());
                    continue block16;
                }
                case "requestId": {
                    requestId = Optional.ofNullable((RequestId)input.read((java.lang.reflect.Type)((Object)RequestId.class)));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Initiator(type, stack, url, lineNumber, columnNumber, requestId);
    }

    public static enum Type {
        PARSER("parser"),
        SCRIPT("script"),
        PRELOAD("preload"),
        SIGNEDEXCHANGE("SignedExchange"),
        PREFLIGHT("preflight"),
        OTHER("other");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s2) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

