/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.backgroundservice.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v110.backgroundservice.model.EventMetadata;
import org.openqa.selenium.devtools.v110.backgroundservice.model.ServiceName;
import org.openqa.selenium.devtools.v110.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v110.serviceworker.model.RegistrationID;
import org.openqa.selenium.json.JsonInput;
import shaded.com.google.common.reflect.TypeToken;

public class BackgroundServiceEvent {
    private final TimeSinceEpoch timestamp;
    private final String origin;
    private final RegistrationID serviceWorkerRegistrationId;
    private final ServiceName service;
    private final String eventName;
    private final String instanceId;
    private final List<EventMetadata> eventMetadata;
    private final String storageKey;

    public BackgroundServiceEvent(TimeSinceEpoch timestamp, String origin, RegistrationID serviceWorkerRegistrationId, ServiceName service, String eventName, String instanceId, List<EventMetadata> eventMetadata, String storageKey) {
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.serviceWorkerRegistrationId = Objects.requireNonNull(serviceWorkerRegistrationId, "serviceWorkerRegistrationId is required");
        this.service = Objects.requireNonNull(service, "service is required");
        this.eventName = Objects.requireNonNull(eventName, "eventName is required");
        this.instanceId = Objects.requireNonNull(instanceId, "instanceId is required");
        this.eventMetadata = Objects.requireNonNull(eventMetadata, "eventMetadata is required");
        this.storageKey = Objects.requireNonNull(storageKey, "storageKey is required");
    }

    public TimeSinceEpoch getTimestamp() {
        return this.timestamp;
    }

    public String getOrigin() {
        return this.origin;
    }

    public RegistrationID getServiceWorkerRegistrationId() {
        return this.serviceWorkerRegistrationId;
    }

    public ServiceName getService() {
        return this.service;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public List<EventMetadata> getEventMetadata() {
        return this.eventMetadata;
    }

    public String getStorageKey() {
        return this.storageKey;
    }

    private static BackgroundServiceEvent fromJson(JsonInput input) {
        TimeSinceEpoch timestamp = null;
        String origin = null;
        RegistrationID serviceWorkerRegistrationId = null;
        ServiceName service = null;
        String eventName = null;
        String instanceId = null;
        List eventMetadata = null;
        String storageKey = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "timestamp": {
                    timestamp = (TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class));
                    continue block20;
                }
                case "origin": {
                    origin = input.nextString();
                    continue block20;
                }
                case "serviceWorkerRegistrationId": {
                    serviceWorkerRegistrationId = (RegistrationID)input.read((Type)((Object)RegistrationID.class));
                    continue block20;
                }
                case "service": {
                    service = (ServiceName)((Object)input.read((Type)((Object)ServiceName.class)));
                    continue block20;
                }
                case "eventName": {
                    eventName = input.nextString();
                    continue block20;
                }
                case "instanceId": {
                    instanceId = input.nextString();
                    continue block20;
                }
                case "eventMetadata": {
                    eventMetadata = (List)input.read(new TypeToken<List<EventMetadata>>(){}.getType());
                    continue block20;
                }
                case "storageKey": {
                    storageKey = input.nextString();
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BackgroundServiceEvent(timestamp, origin, serviceWorkerRegistrationId, service, eventName, instanceId, eventMetadata, storageKey);
    }
}

