/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.cast;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v110.cast.model.Sink;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.reflect.TypeToken;

@Beta
public class Cast {
    public static Command<Void> enable(Optional<String> presentationUrl) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        presentationUrl.ifPresent(p -> params.put("presentationUrl", p));
        return new Command<Void>("Cast.enable", params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Cast.disable", params.build());
    }

    public static Command<Void> setSinkToUse(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("sinkName", sinkName);
        return new Command<Void>("Cast.setSinkToUse", params.build());
    }

    public static Command<Void> startDesktopMirroring(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("sinkName", sinkName);
        return new Command<Void>("Cast.startDesktopMirroring", params.build());
    }

    public static Command<Void> startTabMirroring(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("sinkName", sinkName);
        return new Command<Void>("Cast.startTabMirroring", params.build());
    }

    public static Command<Void> stopCasting(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("sinkName", sinkName);
        return new Command<Void>("Cast.stopCasting", params.build());
    }

    public static Event<List<Sink>> sinksUpdated() {
        return new Event<List<Sink>>("Cast.sinksUpdated", ConverterFunctions.map("sinks", new TypeToken<List<Sink>>(){}.getType()));
    }

    public static Event<String> issueUpdated() {
        return new Event<String>("Cast.issueUpdated", ConverterFunctions.map("issueMessage", String.class));
    }
}

