/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.debugger.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v110.debugger.model.Location;
import org.openqa.selenium.devtools.v110.runtime.model.RemoteObject;
import org.openqa.selenium.json.JsonInput;

public class Scope {
    private final Type type;
    private final RemoteObject object;
    private final Optional<String> name;
    private final Optional<Location> startLocation;
    private final Optional<Location> endLocation;

    public Scope(Type type, RemoteObject object, Optional<String> name, Optional<Location> startLocation, Optional<Location> endLocation) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.object = Objects.requireNonNull(object, "object is required");
        this.name = name;
        this.startLocation = startLocation;
        this.endLocation = endLocation;
    }

    public Type getType() {
        return this.type;
    }

    public RemoteObject getObject() {
        return this.object;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<Location> getStartLocation() {
        return this.startLocation;
    }

    public Optional<Location> getEndLocation() {
        return this.endLocation;
    }

    private static Scope fromJson(JsonInput input) {
        Type type = null;
        RemoteObject object = null;
        Optional<String> name = Optional.empty();
        Optional<Location> startLocation = Optional.empty();
        Optional<Location> endLocation = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block14;
                }
                case "object": {
                    object = (RemoteObject)input.read((java.lang.reflect.Type)((Object)RemoteObject.class));
                    continue block14;
                }
                case "name": {
                    name = Optional.ofNullable(input.nextString());
                    continue block14;
                }
                case "startLocation": {
                    startLocation = Optional.ofNullable((Location)input.read((java.lang.reflect.Type)((Object)Location.class)));
                    continue block14;
                }
                case "endLocation": {
                    endLocation = Optional.ofNullable((Location)input.read((java.lang.reflect.Type)((Object)Location.class)));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Scope(type, object, name, startLocation, endLocation);
    }

    public static enum Type {
        GLOBAL("global"),
        LOCAL("local"),
        WITH("with"),
        CLOSURE("closure"),
        CATCH("catch"),
        BLOCK("block"),
        SCRIPT("script"),
        EVAL("eval"),
        MODULE("module"),
        WASM_EXPRESSION_STACK("wasm-expression-stack");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s2) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

