/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.chromium.ChromiumDriverCommandExecutor;
import org.openqa.selenium.edge.AddHasCasting;
import org.openqa.selenium.edge.AddHasCdp;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebDriverBuilder;
import org.openqa.selenium.remote.service.DriverService;
import shaded.com.google.common.collect.ImmutableMap;

public class EdgeDriver
extends ChromiumDriver {
    public EdgeDriver() {
        this(new EdgeOptions());
    }

    public EdgeDriver(EdgeOptions options) {
        this((EdgeDriverService)new EdgeDriverService.Builder().build(), options);
    }

    public EdgeDriver(EdgeDriverService service) {
        this(service, new EdgeOptions());
    }

    public EdgeDriver(EdgeDriverService service, EdgeOptions options) {
        super(new EdgeDriverCommandExecutor(service), (Capabilities)Require.nonNull("Driver options", options), "ms:edgeOptions");
        this.casting = new AddHasCasting().getImplementation(this.getCapabilities(), this.getExecuteMethod());
        this.cdp = new AddHasCdp().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    }

    @Beta
    public static RemoteWebDriverBuilder builder() {
        return RemoteWebDriver.builder().oneOf(new EdgeOptions(), new Capabilities[0]);
    }

    private static class EdgeDriverCommandExecutor
    extends ChromiumDriverCommandExecutor {
        public EdgeDriverCommandExecutor(DriverService service) {
            super(service, EdgeDriverCommandExecutor.getExtraCommands());
        }

        private static Map<String, CommandInfo> getExtraCommands() {
            return ImmutableMap.builder().putAll(new AddHasCasting().getAdditionalCommands()).putAll(new AddHasCdp().getAdditionalCommands()).build();
        }
    }
}

