/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.firefox.HasFullPageScreenshot;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.http.HttpMethod;
import shaded.com.google.auto.service.AutoService;
import shaded.com.google.common.collect.ImmutableMap;

@AutoService(value={AdditionalHttpCommands.class, AugmenterProvider.class})
public class AddHasFullPageScreenshot<X>
implements AugmenterProvider<HasFullPageScreenshot>,
AdditionalHttpCommands {
    public static final String FULL_PAGE_SCREENSHOT = "fullPageScreenshot";
    private static final Map<String, CommandInfo> COMMANDS = ImmutableMap.of("fullPageScreenshot", new CommandInfo("/session/:sessionId/moz/screenshot/full", HttpMethod.GET));

    @Override
    public Map<String, CommandInfo> getAdditionalCommands() {
        return COMMANDS;
    }

    @Override
    public Predicate<Capabilities> isApplicable() {
        return Browser.FIREFOX::is;
    }

    @Override
    public Class<HasFullPageScreenshot> getDescribedInterface() {
        return HasFullPageScreenshot.class;
    }

    @Override
    public HasFullPageScreenshot getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasFullPageScreenshot(){

            @Override
            public <X> X getFullPageScreenshotAs(OutputType<X> outputType) {
                Require.nonNull("Output Type", outputType);
                Object result = executeMethod.execute(AddHasFullPageScreenshot.FULL_PAGE_SCREENSHOT, null);
                if (result instanceof String) {
                    String base64EncodedPng = (String)result;
                    return outputType.convertFromBase64Png(base64EncodedPng);
                }
                if (result instanceof byte[]) {
                    return outputType.convertFromPngBytes((byte[])result);
                }
                throw new RuntimeException(String.format("Unexpected result for %s command: %s", AddHasFullPageScreenshot.FULL_PAGE_SCREENSHOT, result == null ? "null" : result.getClass().getName() + " instance"));
            }
        };
    }
}

