/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ie.ElementScrollBehavior;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.remote.Browser;

public class InternetExplorerOptions
extends AbstractDriverOptions<InternetExplorerOptions> {
    public static final String IE_OPTIONS = "se:ieOptions";
    private static final String FULL_PAGE_SCREENSHOT = "ie.enableFullPageScreenshot";
    private static final String UPLOAD_DIALOG_TIMEOUT = "ie.fileUploadDialogTimeout";
    private static final String FORCE_WINDOW_SHELL_API = "ie.forceShellWindowsApi";
    private static final String LEGACY_FILE_UPLOAD_DIALOG_HANDLING = "ie.useLegacyFileUploadDialogHandling";
    private static final String ATTACH_TO_EDGE_CHROME = "ie.edgechromium";
    private static final String EDGE_EXECUTABLE_PATH = "ie.edgepath";
    private static final List<String> CAPABILITY_NAMES = Arrays.asList("browserAttachTimeout", "elementScrollBehavior", "enablePersistentHover", "ie.enableFullPageScreenshot", "ie.forceCreateProcessApi", "ie.forceShellWindowsApi", "ie.ensureCleanSession", "ie.browserCommandLineSwitches", "ie.usePerProcessProxy", "ignoreZoomSetting", "initialBrowserUrl", "ignoreProtectedModeSettings", "requireWindowFocus", "ie.fileUploadDialogTimeout", "nativeEvents", "ie.useLegacyFileUploadDialogHandling", "ie.edgechromium", "ie.edgepath");
    private final Map<String, Object> ieOptions = new HashMap<String, Object>();

    public InternetExplorerOptions() {
        this.setCapability("browserName", Browser.IE.browserName());
        this.setCapability(IE_OPTIONS, this.ieOptions);
    }

    public InternetExplorerOptions(Capabilities source) {
        this();
        source.getCapabilityNames().forEach(name -> this.setCapability((String)name, source.getCapability((String)name)));
    }

    @Override
    public InternetExplorerOptions merge(Capabilities extraCapabilities) {
        InternetExplorerOptions newInstance = new InternetExplorerOptions();
        this.asMap().forEach(newInstance::setCapability);
        extraCapabilities.asMap().forEach(newInstance::setCapability);
        return newInstance;
    }

    public InternetExplorerOptions withAttachTimeout(long duration, TimeUnit unit) {
        return this.withAttachTimeout(Duration.ofMillis(unit.toMillis(duration)));
    }

    public InternetExplorerOptions withAttachTimeout(Duration duration) {
        return this.amend("browserAttachTimeout", duration.toMillis());
    }

    public InternetExplorerOptions elementScrollTo(ElementScrollBehavior behavior) {
        return this.amend("elementScrollBehavior", behavior.getValue());
    }

    public InternetExplorerOptions enablePersistentHovering() {
        return this.amend("enablePersistentHover", true);
    }

    public InternetExplorerOptions useCreateProcessApiToLaunchIe() {
        return this.amend("ie.forceCreateProcessApi", true);
    }

    public InternetExplorerOptions useShellWindowsApiToAttachToIe() {
        return this.amend(FORCE_WINDOW_SHELL_API, true);
    }

    public InternetExplorerOptions destructivelyEnsureCleanSession() {
        return this.amend("ie.ensureCleanSession", true);
    }

    public InternetExplorerOptions addCommandSwitches(String ... switches) {
        List<Object> raw = this.getCapability("ie.browserCommandLineSwitches");
        if (raw == null) {
            raw = new LinkedList();
        } else if (raw instanceof String) {
            raw = Arrays.asList(((String)((Object)raw)).split(" "));
        }
        return this.amend("ie.browserCommandLineSwitches", Stream.concat(((List)raw).stream(), Stream.of(switches)).filter(i -> i instanceof String).map(String.class::cast).collect(Collectors.toList()));
    }

    public InternetExplorerOptions usePerProcessProxy() {
        return this.amend("ie.usePerProcessProxy", true);
    }

    public InternetExplorerOptions withInitialBrowserUrl(String url) {
        return this.amend("initialBrowserUrl", Require.nonNull("Initial browser URL", url));
    }

    public InternetExplorerOptions requireWindowFocus() {
        return this.amend("requireWindowFocus", true);
    }

    public InternetExplorerOptions waitForUploadDialogUpTo(long duration, TimeUnit unit) {
        return this.waitForUploadDialogUpTo(Duration.ofMillis(unit.toMillis(duration)));
    }

    public InternetExplorerOptions waitForUploadDialogUpTo(Duration duration) {
        return this.amend(UPLOAD_DIALOG_TIMEOUT, duration.toMillis());
    }

    public InternetExplorerOptions introduceFlakinessByIgnoringSecurityDomains() {
        return this.amend("ignoreProtectedModeSettings", true);
    }

    public InternetExplorerOptions disableNativeEvents() {
        return this.amend("nativeEvents", false);
    }

    public InternetExplorerOptions ignoreZoomSettings() {
        return this.amend("ignoreZoomSetting", true);
    }

    public InternetExplorerOptions takeFullPageScreenshot() {
        return this.amend(FULL_PAGE_SCREENSHOT, true);
    }

    public InternetExplorerOptions useLegacyUploadDialog() {
        return this.amend(LEGACY_FILE_UPLOAD_DIALOG_HANDLING, true);
    }

    public InternetExplorerOptions attachToEdgeChrome() {
        return this.amend(ATTACH_TO_EDGE_CHROME, true);
    }

    public InternetExplorerOptions withEdgeExecutablePath(String path) {
        return this.amend(EDGE_EXECUTABLE_PATH, path);
    }

    private InternetExplorerOptions amend(String optionName, Object value) {
        this.setCapability(optionName, value);
        return this;
    }

    @Override
    public void setCapability(String key, Object value) {
        if ("ie.browserCommandLineSwitches".equals(key) && value instanceof List) {
            value = ((List)value).stream().map(Object::toString).collect(Collectors.joining(" "));
        }
        if (CAPABILITY_NAMES.contains(key)) {
            this.ieOptions.put(key, value);
        } else {
            super.setCapability(key, value);
        }
        if (IE_OPTIONS.equals(key)) {
            Map<String, Object> streamFrom;
            this.ieOptions.clear();
            if (value instanceof Map) {
                streamFrom = (Map<String, Object>)value;
            } else if (value instanceof Capabilities) {
                streamFrom = ((Capabilities)value).asMap();
            } else {
                throw new IllegalArgumentException("Value for " + key + " must be of type Map or Capabilities");
            }
            streamFrom.entrySet().stream().filter(entry -> CAPABILITY_NAMES.contains(entry.getKey())).filter(entry -> entry.getValue() != null).forEach(entry -> {
                if ("ie.browserCommandLineSwitches".equals(entry.getKey())) {
                    this.setCapability((String)entry.getKey(), Arrays.asList(entry.getValue().toString().split(" ")));
                } else {
                    this.setCapability((String)entry.getKey(), entry.getValue());
                }
            });
        }
    }

    @Override
    protected Set<String> getExtraCapabilityNames() {
        return Collections.emptySet();
    }

    @Override
    protected Object getExtraCapability(String capabilityName) {
        Require.nonNull("Capability name", capabilityName);
        return null;
    }
}

