/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.manager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.logging.Logger;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.io.CharStreams;

@Beta
public class SeleniumManager {
    private static final Logger LOG = Logger.getLogger(SeleniumManager.class.getName());
    private static final String SELENIUM_MANAGER = "selenium-manager";
    private static final String EXE = ".exe";
    private static final String INFO = "INFO\t";
    private static SeleniumManager manager;
    private File binary;

    private SeleniumManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.binary != null && this.binary.exists()) {
                try {
                    Files.delete(this.binary.toPath());
                }
                catch (IOException e) {
                    LOG.warning(String.format("%s deleting temporal file: %s", e.getClass().getSimpleName(), e.getMessage()));
                }
            }
        }));
    }

    public static SeleniumManager getInstance() {
        if (manager == null) {
            manager = new SeleniumManager();
        }
        return manager;
    }

    private static String runCommand(String ... command) {
        String output = "";
        int code = 0;
        try {
            Process process = new ProcessBuilder(command).redirectErrorStream(true).start();
            process.waitFor();
            code = process.exitValue();
            output = CharStreams.toString(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            LOG.warning(String.format("Interrupted exception running command %s: %s", Arrays.toString(command), e.getMessage()));
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOG.warning(String.format("%s running command %s: %s", e.getClass().getSimpleName(), Arrays.toString(command), e.getMessage()));
        }
        if (code > 0) {
            throw new WebDriverException("Unsuccessful command executed: " + Arrays.toString(command) + "\n" + output);
        }
        return output.replace(INFO, "").trim();
    }

    private synchronized File getBinary() {
        if (this.binary == null) {
            try {
                Platform current = Platform.getCurrent();
                String folder = "linux";
                String extension = "";
                if (current.is(Platform.WINDOWS)) {
                    extension = EXE;
                    folder = "windows";
                } else if (current.is(Platform.MAC)) {
                    folder = "macos";
                }
                String binaryPath = String.format("%s/%s%s", folder, SELENIUM_MANAGER, extension);
                try (InputStream inputStream = this.getClass().getResourceAsStream(binaryPath);){
                    Path tmpPath = Files.createTempDirectory(SELENIUM_MANAGER + System.nanoTime(), new FileAttribute[0]);
                    File tmpFolder = tmpPath.toFile();
                    tmpFolder.deleteOnExit();
                    this.binary = new File(tmpFolder, SELENIUM_MANAGER + extension);
                    Files.copy(inputStream, this.binary.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                this.binary.setExecutable(true);
            }
            catch (Exception e) {
                throw new WebDriverException("Unable to obtain Selenium Manager", e);
            }
        }
        return this.binary;
    }

    public String getDriverPath(String driverName) {
        if (!ImmutableList.of("geckodriver", "chromedriver", "msedgedriver", "IEDriverServer").contains(driverName)) {
            throw new WebDriverException("Unable to locate driver with name: " + driverName);
        }
        String driverPath = null;
        File binaryFile = this.getBinary();
        if (binaryFile != null) {
            driverPath = SeleniumManager.runCommand(binaryFile.getAbsolutePath(), "--driver", driverName.replaceAll(EXE, ""));
        }
        return driverPath;
    }
}

