/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebDriverBuilder;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.AddHasDebugger;
import org.openqa.selenium.safari.AddHasPermissions;
import org.openqa.selenium.safari.HasDebugger;
import org.openqa.selenium.safari.HasPermissions;
import org.openqa.selenium.safari.SafariDriverService;
import org.openqa.selenium.safari.SafariOptions;
import org.openqa.selenium.safari.SafariTechPreviewDriverService;
import shaded.com.google.common.collect.ImmutableMap;

public class SafariDriver
extends RemoteWebDriver
implements HasPermissions,
HasDebugger {
    private final HasPermissions permissions = new AddHasPermissions().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final HasDebugger debugger = new AddHasDebugger().getImplementation(this.getCapabilities(), this.getExecuteMethod());

    public SafariDriver() {
        this(new SafariOptions());
    }

    public SafariDriver(SafariOptions safariOptions) {
        this(safariOptions.getUseTechnologyPreview() ? SafariTechPreviewDriverService.createDefaultService() : SafariDriverService.createDefaultService(), safariOptions);
    }

    public SafariDriver(SafariDriverService safariService) {
        this(safariService, new SafariOptions());
    }

    public SafariDriver(DriverService safariServer, SafariOptions safariOptions) {
        super(new SafariDriverCommandExecutor(safariServer), (Capabilities)safariOptions);
    }

    @Beta
    public static RemoteWebDriverBuilder builder() {
        return RemoteWebDriver.builder().oneOf(new SafariOptions(), new Capabilities[0]);
    }

    @Override
    public void setPermissions(String permission, boolean value) {
        Require.nonNull("Permission Name", permission);
        Require.nonNull("Permission Value", value);
        this.permissions.setPermissions(permission, value);
    }

    @Override
    public Map<String, Boolean> getPermissions() {
        return this.permissions.getPermissions();
    }

    @Override
    public void attachDebugger() {
        this.debugger.attachDebugger();
    }

    @Override
    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    private static class SafariDriverCommandExecutor
    extends DriverCommandExecutor {
        public SafariDriverCommandExecutor(DriverService service) {
            super(service, SafariDriverCommandExecutor.getExtraCommands());
        }

        private static Map<String, CommandInfo> getExtraCommands() {
            return ImmutableMap.builder().putAll(new AddHasPermissions().getAdditionalCommands()).putAll(new AddHasDebugger().getAdditionalCommands()).build();
        }
    }
}

