/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.library;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.robotframework.javalib.annotation.Autowired;
import org.robotframework.javalib.beans.annotation.AnnotationBasedKeywordFilter;
import org.robotframework.javalib.beans.annotation.IBeanLoader;
import org.robotframework.javalib.beans.annotation.KeywordBeanLoader;
import org.robotframework.javalib.beans.common.IClassFilter;
import org.robotframework.javalib.factory.AnnotationKeywordFactory;
import org.robotframework.javalib.factory.KeywordFactory;
import org.robotframework.javalib.keyword.DocumentedKeyword;
import org.robotframework.javalib.library.KeywordDocumentationRepository;
import org.robotframework.javalib.library.KeywordFactoryBasedLibrary;

public class AnnotationLibrary
extends KeywordFactoryBasedLibrary<DocumentedKeyword>
implements KeywordDocumentationRepository {
    protected List<IBeanLoader> beanLoaders = new ArrayList<IBeanLoader>();
    protected IClassFilter classFilter = new AnnotationBasedKeywordFilter();
    private KeywordFactory<DocumentedKeyword> keywordFactory;

    public AnnotationLibrary() {
    }

    public AnnotationLibrary(String keywordPattern) {
        this.addKeywordPattern(keywordPattern);
    }

    public AnnotationLibrary(List<String> keywordPatterns) {
        for (String pattern : keywordPatterns) {
            this.addKeywordPattern(pattern);
        }
    }

    @Override
    protected KeywordFactory<DocumentedKeyword> createKeywordFactory() {
        this.assumeKeywordPatternIsSet();
        if (this.keywordFactory == null) {
            ArrayList<Map> keywordBeansMaps = new ArrayList<Map>();
            for (IBeanLoader beanLoader : this.beanLoaders) {
                keywordBeansMaps.add(beanLoader.loadBeanDefinitions(this.classFilter));
            }
            this.keywordFactory = new AnnotationKeywordFactory(keywordBeansMaps);
            ArrayList<Object> injectionValues = new ArrayList<Object>();
            injectionValues.add(this);
            for (Map map : keywordBeansMaps) {
                injectionValues.addAll(map.values());
            }
            for (Object e : injectionValues) {
                this.autowireFields(e, injectionValues);
            }
        }
        return this.keywordFactory;
    }

    protected void autowireFields(Object injectionTarget, Collection<Object> injectionValues) {
        for (Class<?> objectClass = injectionTarget.getClass(); objectClass != null; objectClass = objectClass.getSuperclass()) {
            Field[] fields;
            block3: for (Field field : fields = objectClass.getDeclaredFields()) {
                try {
                    if (!field.isAnnotationPresent(Autowired.class)) continue;
                    if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) || field.isAccessible())) {
                        field.setAccessible(true);
                    }
                    Class<?> fieldClass = field.getType();
                    for (Object injectionValue : injectionValues) {
                        if (!injectionValue.getClass().equals(fieldClass)) continue;
                        field.set(injectionTarget, injectionValue);
                        continue block3;
                    }
                    throw new IllegalArgumentException(String.format("Can't autowire field '%s' at keyword class '%s'.", field.getName(), injectionTarget.getClass().getName()));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(String.format("Can't autowire field '%s' at keyword class '%s'.", field.getName(), injectionTarget.getClass().getName()), e);
                }
            }
        }
    }

    @Override
    public List<String> getKeywordArguments(String keywordName) {
        List<String> argumentNames = this.createKeywordFactory().createKeyword(keywordName).getArgumentNames();
        return argumentNames;
    }

    @Override
    public String getKeywordDocumentation(String keywordName) {
        if (keywordName.equals("__intro__")) {
            return "";
        }
        return this.createKeywordFactory().createKeyword(keywordName).getDocumentation();
    }

    @Override
    public Object runKeyword(String keywordName, List args, Map kwargs) {
        try {
            return super.runKeyword(keywordName, args, kwargs);
        }
        catch (RuntimeException e) {
            throw this.retrieveInnerException(e);
        }
    }

    @Override
    public Object runKeyword(String keywordName, List args) {
        try {
            return super.runKeyword(keywordName, args);
        }
        catch (RuntimeException e) {
            throw this.retrieveInnerException(e);
        }
    }

    public void addKeywordPattern(String keywordPattern) {
        this.beanLoaders.add(new KeywordBeanLoader(keywordPattern, Thread.currentThread().getContextClassLoader()));
    }

    private void assumeKeywordPatternIsSet() {
        if (this.beanLoaders.isEmpty()) {
            throw new IllegalStateException("Keyword pattern must be set before calling getKeywordNames.");
        }
    }

    private RuntimeException retrieveInnerException(RuntimeException e) {
        Throwable cause = e.getCause();
        if (cause != null && InvocationTargetException.class.equals(cause.getClass())) {
            Throwable original = cause.getCause();
            return new RuntimeException(original.getMessage(), original);
        }
        return e;
    }
}

