/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.library;

import java.util.List;
import java.util.Map;
import org.robotframework.javalib.factory.KeywordFactory;
import org.robotframework.javalib.keyword.Keyword;
import org.robotframework.javalib.library.RobotFrameworkDynamicAPI;

public abstract class KeywordFactoryBasedLibrary<T extends Keyword>
implements RobotFrameworkDynamicAPI {
    private KeywordFactory<T> keywordFactory;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    @Override
    public Object runKeyword(String keywordName, List args, Map kwargs) {
        T keyword = this.getKeywordFactory().createKeyword(keywordName);
        return keyword.execute(args, kwargs);
    }

    @Override
    public Object runKeyword(String keywordName, List args) {
        return this.runKeyword(keywordName, args, null);
    }

    @Override
    public List<String> getKeywordNames() {
        return this.getKeywordFactory().getKeywordNames();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected abstract KeywordFactory<T> createKeywordFactory();

    KeywordFactory<T> getKeywordFactory() {
        if (this.keywordFactory == null) {
            this.keywordFactory = this.createKeywordFactory();
        }
        return this.keywordFactory;
    }
}

