/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.reflection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.robotframework.javalib.reflection.IArgumentCollector;

public class ArgumentCollector
implements IArgumentCollector {
    private final Class<?>[] parameterTypes;
    private final List<String> parameterNames;

    public ArgumentCollector(Class<?>[] parameterTypes, List<String> parameterNames) {
        this.parameterNames = parameterNames;
        this.parameterTypes = parameterTypes;
    }

    @Override
    public List collectArguments(List args, Map<String, Object> kwargs) {
        ArrayList<Object> collectedArguments = new ArrayList<Object>();
        HashMap<String, Object> cleanedKwargs = new HashMap<String, Object>();
        if (kwargs != null) {
            cleanedKwargs.putAll(kwargs);
        }
        boolean hasVarargs = this.keywordHasVarargs();
        boolean hasKwargs = this.keywordHasKwargs();
        if (this.parameterNames != null && this.parameterNames.size() > 0) {
            int i;
            List filteredList = this.parameterNames.stream().filter(line -> !line.contains("*")).collect(Collectors.toList());
            for (int i2 = 0; i2 < filteredList.size(); ++i2) {
                collectedArguments.add(null);
            }
            ArrayList<Object> varargs = new ArrayList<Object>();
            for (i = 0; i < this.parameterNames.size(); ++i) {
                Class<Object> argumentType;
                String parameterName = this.parameterNames.get(i).split("=")[0];
                boolean vararg = parameterName.contains("*");
                boolean kwarg = parameterName.contains("**");
                parameterName = parameterName.replace("*", "").replace("*", "");
                Object value = this.getParameterValue(parameterName, i, args, cleanedKwargs);
                Class clazz = argumentType = this.parameterTypes.length > i && !vararg ? this.parameterTypes[i] : Object.class;
                if (kwarg) continue;
                if (vararg) {
                    if (value == null) continue;
                    varargs.add(this.convertToType(argumentType, value));
                    continue;
                }
                collectedArguments.set(i, this.convertToType(argumentType, value));
            }
            if (hasVarargs && args != null && args.size() > filteredList.size()) {
                for (i = filteredList.size() + 1; i < args.size(); ++i) {
                    varargs.add(args.get(i));
                }
            }
            if (hasVarargs) {
                collectedArguments.add(this.ensureCorrectVarargsType(varargs));
            }
        }
        if (hasKwargs) {
            collectedArguments.add(cleanedKwargs);
        }
        return collectedArguments;
    }

    private int getVarargsIndex() {
        int parameterSize;
        int n = parameterSize = this.parameterNames != null ? this.parameterNames.size() : -1;
        if (parameterSize > 0 && this.parameterNames.get(parameterSize - 1).startsWith("*") && !this.parameterNames.get(parameterSize - 1).startsWith("**")) {
            return parameterSize - 1;
        }
        if (parameterSize > 1 && this.parameterNames.get(parameterSize - 2).startsWith("*") && !this.parameterNames.get(parameterSize - 2).startsWith("**")) {
            return parameterSize - 2;
        }
        return -1;
    }

    private Object getParameterValue(String parameterName, int i, List args, Map<String, Object> kwargs) {
        Object value;
        Object parameterDefaultValue = this.parameterNames.get(i).contains("=") && this.parameterNames.get(i).split("=").length > 1 ? this.parameterNames.get(i).split("=")[1] : null;
        Object object = value = args != null && args.size() > i ? (Object)args.get(i) : parameterDefaultValue;
        if (kwargs != null && kwargs.containsKey(parameterName)) {
            value = kwargs.get(parameterName);
            kwargs.remove(parameterName);
        }
        return value;
    }

    private Object ensureCorrectVarargsType(List varargs) {
        int varargIndex = this.getVarargsIndex();
        if (this.parameterTypes != null && varargIndex > -1 && this.parameterTypes[varargIndex].isArray()) {
            Class<?> arrayClass = this.parameterTypes[varargIndex].getComponentType();
            Object[] varargsArray = (Object[])Array.newInstance(arrayClass, varargs.size());
            for (int i = 0; i < varargs.size(); ++i) {
                varargsArray[i] = varargs.get(i);
            }
            return varargsArray;
        }
        return varargs;
    }

    private boolean keywordHasVarargs() {
        return this.getVarargsIndex() > -1;
    }

    private boolean keywordHasKwargs() {
        return this.parameterNames != null && this.parameterNames.size() > 0 && this.parameterNames.get(this.parameterNames.size() - 1).startsWith("**");
    }

    private Object convertToType(Class<?> clazz, Object object) {
        if (object != null) {
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return Integer.valueOf(object.toString());
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return Long.valueOf(object.toString());
            }
            if (clazz == Short.class || clazz == Short.TYPE) {
                return Short.valueOf(object.toString());
            }
            if (clazz == Byte.class || clazz == Byte.TYPE) {
                return Byte.valueOf(object.toString());
            }
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return Boolean.valueOf(object.toString());
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                return Float.valueOf(object.toString());
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                return Double.valueOf(object.toString());
            }
            if (clazz == String.class) {
                return object.toString();
            }
            if (object.getClass().isArray() && clazz.isAssignableFrom(List.class)) {
                return Arrays.asList((Object[])object);
            }
            if (List.class.isAssignableFrom(object.getClass()) && clazz.isArray()) {
                return ((List)object).toArray();
            }
        }
        return object;
    }
}

