/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.reflection.ArgumentCollector;
import org.robotframework.javalib.reflection.IArgumentCollector;
import org.robotframework.javalib.reflection.IKeywordInvoker;

public class KeywordInvoker
implements IKeywordInvoker {
    private final Method method;
    private final Object obj;

    public KeywordInvoker(Object obj, Method method) {
        this.obj = obj;
        this.method = method;
    }

    @Override
    public List<String> getParameterNames() {
        if (this.method.isAnnotationPresent(ArgumentNames.class)) {
            List<String> argumentNames = Arrays.asList(this.method.getAnnotation(ArgumentNames.class).value());
            return argumentNames;
        }
        return this.getParameterNamesFromMethod();
    }

    @Override
    public List<String> getParameterTypes() {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        for (Class<?> parameterClass : this.method.getParameterTypes()) {
            parameterTypes.add(parameterClass.getSimpleName());
        }
        return parameterTypes;
    }

    @Override
    public Object invoke(List args, Map kwargs) {
        try {
            List reflectionArgs = this.createArgumentCollector().collectArguments(args, kwargs);
            Object[] reflectionArgsArray = reflectionArgs != null ? reflectionArgs.toArray() : null;
            return this.method.invoke(this.obj, reflectionArgsArray);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDocumentation() {
        return this.method.getAnnotation(RobotKeyword.class).value();
    }

    IArgumentCollector createArgumentCollector() {
        return new ArgumentCollector(this.method.getParameterTypes(), this.getParameterNames());
    }

    private List<String> getParameterNamesFromMethod() {
        List<String> parameterNameList = this.getParameterNamesWithReflection();
        if (this.method.getParameterCount() > 0) {
            int lastParameterIndex = this.method.getParameterCount() - 1;
            Class<?> lastParameterType = this.method.getParameters()[lastParameterIndex].getType();
            if (lastParameterType.equals(List.class) || lastParameterType.isArray() && lastParameterType != byte[].class) {
                parameterNameList.set(lastParameterIndex, "*" + parameterNameList.get(lastParameterIndex));
            } else if (this.method.getParameters()[lastParameterIndex].getType().equals(Map.class)) {
                if (lastParameterIndex > 1 && (this.method.getParameters()[lastParameterIndex - 1].getType().equals(List.class) || this.method.getParameters()[lastParameterIndex - 1].getType().isArray() && this.method.getParameters()[lastParameterIndex - 1].getType() != byte[].class)) {
                    parameterNameList.set(lastParameterIndex - 1, "*" + parameterNameList.get(lastParameterIndex - 1));
                }
                parameterNameList.set(lastParameterIndex, "**" + parameterNameList.get(lastParameterIndex));
            }
        }
        return parameterNameList;
    }

    private List<String> getParameterNamesWithReflection() {
        ArrayList<String> parameterNameList = new ArrayList<String>();
        for (Parameter parameter : this.method.getParameters()) {
            parameterNameList.add(parameter.getName());
        }
        return parameterNameList;
    }
}

