/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.AutoValue_DoubleBase2ExponentialHistogramAggregator_EmptyExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleBase2ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableExponentialHistogramData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableExponentialHistogramPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import shaded.com.google.auto.value.AutoValue;

public final class DoubleBase2ExponentialHistogramAggregator
implements Aggregator<ExponentialHistogramPointData, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;
    private final int maxBuckets;
    private final int maxScale;

    public DoubleBase2ExponentialHistogramAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, int maxBuckets, int maxScale) {
        this.reservoirSupplier = reservoirSupplier;
        this.maxBuckets = maxBuckets;
        this.maxScale = maxScale;
    }

    @Override
    public AggregatorHandle<ExponentialHistogramPointData, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get(), this.maxBuckets, this.maxScale);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Collection<ExponentialHistogramPointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createExponentialHistogram(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ImmutableExponentialHistogramData.create(temporality, points));
    }

    static final class Handle
    extends AggregatorHandle<ExponentialHistogramPointData, DoubleExemplarData> {
        private final int maxBuckets;
        @Nullable
        private DoubleBase2ExponentialHistogramBuckets positiveBuckets;
        @Nullable
        private DoubleBase2ExponentialHistogramBuckets negativeBuckets;
        private long zeroCount;
        private double sum;
        private double min;
        private double max;
        private long count;
        private int scale;

        Handle(ExemplarReservoir<DoubleExemplarData> reservoir, int maxBuckets, int maxScale) {
            super(reservoir);
            this.maxBuckets = maxBuckets;
            this.sum = 0.0;
            this.zeroCount = 0L;
            this.min = Double.MAX_VALUE;
            this.max = -1.0;
            this.count = 0L;
            this.scale = maxScale;
        }

        @Override
        protected synchronized ExponentialHistogramPointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars, boolean reset) {
            ExponentialHistogramPointData point = ImmutableExponentialHistogramPointData.create(this.scale, this.sum, this.zeroCount, this.count > 0L, this.min, this.count > 0L, this.max, Handle.resolveBuckets(this.positiveBuckets, this.scale, reset), Handle.resolveBuckets(this.negativeBuckets, this.scale, reset), startEpochNanos, epochNanos, attributes, exemplars);
            if (reset) {
                this.sum = 0.0;
                this.zeroCount = 0L;
                this.min = Double.MAX_VALUE;
                this.max = -1.0;
                this.count = 0L;
            }
            return point;
        }

        private static ExponentialHistogramBuckets resolveBuckets(@Nullable DoubleBase2ExponentialHistogramBuckets buckets, int scale, boolean reset) {
            if (buckets == null) {
                return EmptyExponentialHistogramBuckets.get(scale);
            }
            DoubleBase2ExponentialHistogramBuckets copy = buckets.copy();
            if (reset) {
                buckets.clear();
            }
            return copy;
        }

        @Override
        protected synchronized void doRecordDouble(double value) {
            DoubleBase2ExponentialHistogramBuckets buckets;
            if (!Double.isFinite(value)) {
                return;
            }
            this.sum += value;
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
            ++this.count;
            int c = Double.compare(value, 0.0);
            if (c == 0) {
                ++this.zeroCount;
                return;
            }
            if (c > 0) {
                if (this.positiveBuckets == null) {
                    this.positiveBuckets = new DoubleBase2ExponentialHistogramBuckets(this.scale, this.maxBuckets);
                }
                buckets = this.positiveBuckets;
            } else {
                if (this.negativeBuckets == null) {
                    this.negativeBuckets = new DoubleBase2ExponentialHistogramBuckets(this.scale, this.maxBuckets);
                }
                buckets = this.negativeBuckets;
            }
            if (!buckets.record(value)) {
                this.downScale(buckets.getScaleReduction(value));
                buckets.record(value);
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.doRecordDouble(value);
        }

        void downScale(int by) {
            if (this.positiveBuckets != null) {
                this.positiveBuckets.downscale(by);
                this.scale = this.positiveBuckets.getScale();
            }
            if (this.negativeBuckets != null) {
                this.negativeBuckets.downscale(by);
                this.scale = this.negativeBuckets.getScale();
            }
        }
    }

    @AutoValue
    static abstract class EmptyExponentialHistogramBuckets
    implements ExponentialHistogramBuckets {
        private static final Map<Integer, ExponentialHistogramBuckets> ZERO_BUCKETS = new ConcurrentHashMap<Integer, ExponentialHistogramBuckets>();

        EmptyExponentialHistogramBuckets() {
        }

        static ExponentialHistogramBuckets get(int scale) {
            return ZERO_BUCKETS.computeIfAbsent(scale, scale1 -> new AutoValue_DoubleBase2ExponentialHistogramAggregator_EmptyExponentialHistogramBuckets((int)scale1, 0, Collections.emptyList(), 0L));
        }
    }
}

