/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.keyboard;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;

public class UserAuthKeyboardInteractive
extends AbstractUserAuth {
    public static final String NAME = "keyboard-interactive";
    private final AtomicBoolean requestPending = new AtomicBoolean(false);
    private final AtomicInteger trialsCount = new AtomicInteger(0);
    private final AtomicInteger emptyCount = new AtomicInteger(0);
    private Iterator<String> passwords;
    private int maxTrials;

    public UserAuthKeyboardInteractive() {
        super(NAME);
    }

    @Override
    public void init(ClientSession session, String service) throws Exception {
        super.init(session, service);
        this.passwords = ClientSession.passwordIteratorOf(session);
        this.maxTrials = CoreModuleProperties.PASSWORD_PROMPTS.getRequired(session);
        ValidateUtils.checkTrue(this.maxTrials > 0, "Non-positive max. trials: %d", this.maxTrials);
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        String name = this.getName();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.requestPending.get()) {
            if (debugEnabled) {
                this.log.debug("sendAuthDataRequest({})[{}] no reply for previous request for {}", session, service, name);
            }
            return false;
        }
        if (!this.verifyTrialsCount(session, service, 50, this.trialsCount.get(), this.maxTrials)) {
            return false;
        }
        String username = session.getUsername();
        String lang = this.getExchangeLanguageTag(session);
        String subMethods = this.getExchangeSubMethods(session);
        if (debugEnabled) {
            this.log.debug("sendAuthDataRequest({})[{}] send SSH_MSG_USERAUTH_REQUEST for {}: lang={}, methods={}", session, service, name, lang, subMethods);
        }
        int length = username.length() + service.length() + name.length() + GenericUtils.length(lang) + GenericUtils.length(subMethods) + 64;
        Buffer buffer = session.createBuffer((byte)50, length);
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString(name);
        buffer.putString(lang);
        buffer.putString(subMethods);
        this.requestPending.set(true);
        session.writePacket(buffer);
        return true;
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session, String service, Buffer buffer) throws Exception {
        int retriesCount;
        int cmd = buffer.getUByte();
        if (cmd != 60) {
            throw new IllegalStateException("processAuthDataRequest(" + session + ")[" + service + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName(cmd));
        }
        this.requestPending.set(false);
        String name = buffer.getString();
        String instruction = buffer.getString();
        String lang = buffer.getString();
        int num = buffer.getInt();
        if (num < 0 || num > 32768) {
            this.log.error("processAuthDataRequest({})[{}] illogical challenges count ({}) for name={}, instruction={}", session, service, num, name, instruction);
            throw new IndexOutOfBoundsException("Illogical challenges count: " + num);
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("processAuthDataRequest({})[{}] SSH_MSG_USERAUTH_INFO_REQUEST name={}, instruction={}, language={}, num-prompts={}", session, service, name, instruction, lang, num);
        }
        int n = retriesCount = num > 0 ? this.trialsCount.incrementAndGet() : this.emptyCount.incrementAndGet();
        if (!this.verifyTrialsCount(session, service, cmd, retriesCount, this.maxTrials)) {
            return false;
        }
        String[] prompt = num > 0 ? new String[num] : GenericUtils.EMPTY_STRING_ARRAY;
        boolean[] echo = num > 0 ? new boolean[num] : GenericUtils.EMPTY_BOOLEAN_ARRAY;
        boolean traceEnabled = this.log.isTraceEnabled();
        for (int i = 0; i < num; ++i) {
            prompt[i] = buffer.getString();
            echo[i] = buffer.getBoolean();
            if (!traceEnabled) continue;
            this.log.trace("processAuthDataRequest({})[{}]({}) {}/{}: echo={}, prompt={}", session, service, name, i + 1, num, echo[i], prompt[i]);
        }
        String[] rep = this.getUserResponses(name, instruction, lang, prompt, echo);
        if (rep == null) {
            if (debugEnabled) {
                this.log.debug("processAuthDataRequest({})[{}] no responses for {}", session, service, name);
            }
            return false;
        }
        if (num != rep.length) {
            this.log.warn("processAuthDataRequest({})[{}] Mismatched prompts ({}) vs. responses count ({})", session, service, num, rep.length);
        }
        int numResponses = rep.length;
        buffer = session.createBuffer((byte)61, numResponses * 64 + 8);
        buffer.putUInt(numResponses);
        for (int index = 0; index < numResponses; ++index) {
            String r = rep[index];
            if (traceEnabled) {
                this.log.trace("processAuthDataRequest({})[{}] response #{}: {}", session, service, index + 1, r);
            }
            buffer.putString(r);
        }
        session.writePacket(buffer);
        return true;
    }

    protected String getExchangeLanguageTag(ClientSession session) {
        return CoreModuleProperties.INTERACTIVE_LANGUAGE_TAG.getRequired(session);
    }

    protected String getExchangeSubMethods(ClientSession session) {
        return CoreModuleProperties.INTERACTIVE_SUBMETHODS.getRequired(session);
    }

    protected String getCurrentPasswordCandidate() {
        if (this.passwords != null && this.passwords.hasNext()) {
            return this.passwords.next();
        }
        return null;
    }

    protected boolean verifyTrialsCount(ClientSession session, String service, int cmd, int nbTrials, int maxAllowed) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("verifyTrialsCount({})[{}] cmd={} - {} out of {}", session, service, UserAuthKeyboardInteractive.getAuthCommandName(cmd), nbTrials, maxAllowed);
        }
        return nbTrials <= maxAllowed;
    }

    protected String[] getUserResponses(String name, String instruction, String lang, String[] prompt, boolean[] echo) {
        String candidate;
        ClientSession session = this.getClientSession();
        int num = GenericUtils.length(prompt);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (num == 0) {
            if (debugEnabled) {
                this.log.debug("getUserResponses({}) no prompts for interaction={}", (Object)session, (Object)name);
            }
            return GenericUtils.EMPTY_STRING_ARRAY;
        }
        if (PropertyResolverUtils.getBooleanProperty(session, "user-interaction-auto-detect-password-prompt", true) && this.useCurrentPassword(session, candidate = this.getCurrentPasswordCandidate(), name, instruction, lang, prompt, echo)) {
            if (debugEnabled) {
                this.log.debug("getUserResponses({}) use password candidate for interaction={}", (Object)session, (Object)name);
            }
            return new String[]{candidate};
        }
        UserInteraction ui = session.getUserInteraction();
        try {
            if (ui != null && ui.isInteractionAllowed(session)) {
                return ui.interactive(session, name, instruction, lang, prompt, echo);
            }
        }
        catch (Error e) {
            this.warn("getUserResponses({}) failed ({}) to consult interaction: {}", session, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        if (debugEnabled) {
            this.log.debug("getUserResponses({}) no user interaction for name={}", (Object)session, (Object)name);
        }
        return null;
    }

    protected boolean useCurrentPassword(ClientSession session, String password, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
        String promptList;
        int num = GenericUtils.length(prompt);
        if (num != 1 || password == null || echo[0]) {
            return false;
        }
        String value = GenericUtils.trimToEmpty(prompt[0]);
        int passPos = UserInteraction.findPromptComponentLastPosition(value = value.toLowerCase(), promptList = PropertyResolverUtils.getStringProperty(session, "user-interaction-password-prompt", "password"));
        if (passPos < 0) {
            return false;
        }
        String delimList = PropertyResolverUtils.getStringProperty(session, "user-interaction-check-password-delimiter", ":");
        if (PropertyResolverUtils.isNoneValue(delimList)) {
            return true;
        }
        int sepPos = UserInteraction.findPromptComponentLastPosition(value, delimList);
        return sepPos >= passPos;
    }

    public static String getAuthCommandName(int cmd) {
        switch (cmd) {
            case 50: {
                return "SSH_MSG_USERAUTH_REQUEST";
            }
            case 60: {
                return "SSH_MSG_USERAUTH_INFO_REQUEST";
            }
        }
        return SshConstants.getCommandMessageName(cmd);
    }
}

