/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart.part;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.asynchttpclient.request.body.multipart.FileLikePart;
import org.asynchttpclient.request.body.multipart.part.MultipartPart;
import org.asynchttpclient.request.body.multipart.part.MultipartState;
import shaded.io.netty.buffer.ByteBuf;
import shaded.io.netty.buffer.ByteBufAllocator;
import shaded.io.netty.buffer.Unpooled;

public class MessageEndMultipartPart
extends MultipartPart<FileLikePart> {
    private ByteBuf contentBuffer;

    public MessageEndMultipartPart(byte[] boundary) {
        super(null, boundary);
        this.state = MultipartState.PRE_CONTENT;
    }

    @Override
    public long transferTo(ByteBuf target) {
        return this.transfer(this.lazyLoadContentBuffer(), target, MultipartState.DONE);
    }

    @Override
    public long transferTo(WritableByteChannel target) throws IOException {
        this.slowTarget = false;
        return this.transfer(this.lazyLoadContentBuffer(), target, MultipartState.DONE);
    }

    private ByteBuf lazyLoadContentBuffer() {
        if (this.contentBuffer == null) {
            this.contentBuffer = ByteBufAllocator.DEFAULT.buffer((int)this.getContentLength());
            this.contentBuffer.writeBytes(EXTRA_BYTES).writeBytes(this.boundary).writeBytes(EXTRA_BYTES).writeBytes(CRLF_BYTES);
        }
        return this.contentBuffer;
    }

    @Override
    protected int computePreContentLength() {
        return 0;
    }

    @Override
    protected ByteBuf computePreContentBytes(int preContentLength) {
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    protected int computePostContentLength() {
        return 0;
    }

    @Override
    protected ByteBuf computePostContentBytes(int postContentLength) {
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    protected long getContentLength() {
        return EXTRA_BYTES.length + this.boundary.length + EXTRA_BYTES.length + CRLF_BYTES.length;
    }

    @Override
    protected long transferContentTo(ByteBuf target) {
        throw new UnsupportedOperationException("Not supposed to be called");
    }

    @Override
    protected long transferContentTo(WritableByteChannel target) {
        throw new UnsupportedOperationException("Not supposed to be called");
    }

    @Override
    public void close() {
        super.close();
        if (this.contentBuffer != null) {
            this.contentBuffer.release();
        }
    }
}

