/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ndviet.library.configuration.Configuration;
import org.ndviet.library.configuration.ConfigurationInterface;
import org.ndviet.library.configuration.ConfigurationOrdering;
import org.ndviet.library.configuration.PropertiesConfiguration;

public class ConfigurationFactory
implements ConfigurationInterface {
    private static ConfigurationFactory m_instance = null;
    private static ConfigurationOrdering m_configurations;

    public ConfigurationFactory() throws Exception {
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
        propertiesConfiguration.readConfigurationFrom(null);
        List<String> configurationOrdering = this.extractOrderingConfigurations(propertiesConfiguration);
        m_configurations = new ConfigurationOrdering(propertiesConfiguration.getValue("configuration.base"), configurationOrdering);
    }

    public static ConfigurationFactory getInstance() {
        if (m_instance == null) {
            try {
                m_instance = new ConfigurationFactory();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return m_instance;
    }

    private List<String> extractOrderingConfigurations(Configuration configuration) {
        ArrayList<String> listKeys = new ArrayList<String>();
        for (String key : configuration.getData().keySet()) {
            if (!key.contains("configuration.ordering")) continue;
            listKeys.add(key);
        }
        listKeys.stream().sorted().collect(Collectors.toList());
        ArrayList<String> listFiles = new ArrayList<String>();
        for (String key : listKeys) {
            if (configuration.getValue(key) == null || configuration.getValue(key).isEmpty()) continue;
            listFiles.add(configuration.getValue(key));
        }
        return listFiles;
    }

    @Override
    public String getValue(String key) {
        return m_configurations.getValue(key);
    }

    @Override
    public List<String> getListValues(String key) {
        return m_configurations.getListValues(key);
    }
}

