/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class CdpEndpointFinder {
    private static final Logger LOG = Logger.getLogger(CdpEndpointFinder.class.getName());
    private static final Json JSON = new Json();

    public static Optional<URI> getCdpEndPoint(HttpClient.Factory clientFactory, URI reportedUri) {
        HttpResponse res;
        Require.nonNull("HTTP client factory", clientFactory);
        Require.nonNull("DevTools URI", reportedUri);
        ClientConfig config = ClientConfig.defaultConfig().baseUri(reportedUri);
        try (HttpClient client = clientFactory.createClient(config);){
            res = client.execute(new HttpRequest(HttpMethod.GET, "/json/version"));
        }
        catch (UncheckedIOException e) {
            LOG.warning("Unable to connect to determine websocket url: " + e.getMessage());
            return Optional.empty();
        }
        if (res.getStatus() != 200) {
            return Optional.empty();
        }
        Map versionData = (Map)JSON.toType(Contents.string(res), Json.MAP_TYPE);
        Object raw = versionData.get("webSocketDebuggerUrl");
        if (!(raw instanceof String)) {
            return Optional.empty();
        }
        String debuggerUrl = (String)raw;
        try {
            return Optional.of(new URI(debuggerUrl));
        }
        catch (URISyntaxException e) {
            LOG.warning("Invalid URI for endpoint " + raw);
            return Optional.empty();
        }
    }

    public static Optional<URI> getReportedUri(Capabilities caps) {
        String key;
        switch (caps.getBrowserName()) {
            case "chrome": {
                key = "goog:chromeOptions";
                break;
            }
            case "msedge": {
                key = "ms:edgeOptions";
                break;
            }
            case "firefox": {
                key = "moz:debuggerAddress";
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        return CdpEndpointFinder.getReportedUri(key, caps);
    }

    public static Optional<URI> getReportedUri(String capabilityKey, Capabilities caps) {
        Object raw = caps.getCapability(capabilityKey);
        if (raw instanceof Map) {
            raw = ((Map)raw).get("debuggerAddress");
        }
        if (!(raw instanceof String)) {
            LOG.fine("No debugger address");
            return Optional.empty();
        }
        int index = ((String)raw).lastIndexOf(58);
        if (index == -1 || index == ((String)raw).length() - 1) {
            LOG.fine("No index in " + raw);
            return Optional.empty();
        }
        try {
            URI uri = new URI(String.format("http://%s", raw));
            LOG.fine("URI found: " + uri);
            return Optional.of(uri);
        }
        catch (URISyntaxException e) {
            LOG.warning("Unable to create URI from: " + raw);
            return Optional.empty();
        }
    }
}

