/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.devtools.CdpInfo;
import org.openqa.selenium.internal.Require;
import shaded.com.google.common.collect.ImmutableSet;

public class CdpVersionFinder {
    private static final Logger LOG = Logger.getLogger(CdpVersionFinder.class.getName());
    private final int fudgeFactor;
    private final Set<CdpInfo> infos;
    private static final Pattern MAJOR_VERSION_EXTRACTOR = Pattern.compile(".*/(\\d+)\\..*");
    private static final Pattern BROWSER_NAME_VERSION = Pattern.compile("(\\d+)\\..*");

    public CdpVersionFinder() {
        this(5, StreamSupport.stream(ServiceLoader.load(CdpInfo.class, CdpVersionFinder.class.getClassLoader()).spliterator(), false).collect(Collectors.toSet()));
    }

    public CdpVersionFinder(int versionFudgeFactor, Collection<CdpInfo> infos) {
        this.fudgeFactor = Require.nonNegative("Version fudge factor", versionFudgeFactor);
        Require.nonNull("CDP versions", infos);
        this.infos = ImmutableSet.copyOf(infos);
    }

    public Optional<CdpInfo> match(Map<String, Object> versionJson) {
        Require.nonNull("JSON", versionJson);
        Object rawBrowser = versionJson.get("Browser");
        if (!(rawBrowser instanceof String)) {
            return Optional.empty();
        }
        Matcher matcher = MAJOR_VERSION_EXTRACTOR.matcher(rawBrowser.toString());
        return this.fromMatcher(matcher);
    }

    public Optional<CdpInfo> match(String browserVersion) {
        Require.nonNull("Browser version", browserVersion);
        Matcher matcher = BROWSER_NAME_VERSION.matcher(browserVersion);
        return this.fromMatcher(matcher);
    }

    private Optional<CdpInfo> fromMatcher(Matcher matcher) {
        if (matcher.matches()) {
            String major = matcher.group(1);
            try {
                int version = Integer.parseInt(major);
                return this.findNearestMatch(version);
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<CdpInfo> findNearestMatch(int version) {
        CdpInfo nearestMatch = null;
        for (CdpInfo info : this.infos) {
            if (info.getMajorVersion() == version) {
                LOG.log(Level.FINE, "Found exact CDP implementation for version {0}", version);
                return Optional.of(info);
            }
            if (info.getMajorVersion() > version || version - info.getMajorVersion() >= this.fudgeFactor || nearestMatch != null && info.getMajorVersion() <= nearestMatch.getMajorVersion()) continue;
            nearestMatch = info;
        }
        if (nearestMatch == null) {
            LOG.log(Level.WARNING, "Unable to find CDP implementation matching {0}", version);
        } else {
            LOG.log(Level.WARNING, "Unable to find an exact match for CDP version {0}, so returning the closest version found: {1}", new Object[]{version, nearestMatch.getMajorVersion()});
        }
        return Optional.ofNullable(nearestMatch);
    }
}

