/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v109.browser.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DownloadProgress {
    private final String guid;
    private final Number totalBytes;
    private final Number receivedBytes;
    private final State state;

    public DownloadProgress(String guid, Number totalBytes, Number receivedBytes, State state) {
        this.guid = Objects.requireNonNull(guid, "guid is required");
        this.totalBytes = Objects.requireNonNull(totalBytes, "totalBytes is required");
        this.receivedBytes = Objects.requireNonNull(receivedBytes, "receivedBytes is required");
        this.state = Objects.requireNonNull(state, "state is required");
    }

    public String getGuid() {
        return this.guid;
    }

    public Number getTotalBytes() {
        return this.totalBytes;
    }

    public Number getReceivedBytes() {
        return this.receivedBytes;
    }

    public State getState() {
        return this.state;
    }

    private static DownloadProgress fromJson(JsonInput input) {
        String guid = null;
        Number totalBytes = 0;
        Number receivedBytes = 0;
        State state = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "guid": {
                    guid = input.nextString();
                    continue block12;
                }
                case "totalBytes": {
                    totalBytes = input.nextNumber();
                    continue block12;
                }
                case "receivedBytes": {
                    receivedBytes = input.nextNumber();
                    continue block12;
                }
                case "state": {
                    state = State.fromString(input.nextString());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DownloadProgress(guid, totalBytes, receivedBytes, state);
    }

    public static enum State {
        INPROGRESS("inProgress"),
        COMPLETED("completed"),
        CANCELED("canceled");

        private String value;

        private State(String value) {
            this.value = value;
        }

        public static State fromString(String s2) {
            return Arrays.stream(State.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within State "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static State fromJson(JsonInput input) {
            return State.fromString(input.nextString());
        }
    }
}

