/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v111.cachestorage;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v111.cachestorage.model.Cache;
import org.openqa.selenium.devtools.v111.cachestorage.model.CacheId;
import org.openqa.selenium.devtools.v111.cachestorage.model.CachedResponse;
import org.openqa.selenium.devtools.v111.cachestorage.model.DataEntry;
import org.openqa.selenium.devtools.v111.cachestorage.model.Header;
import org.openqa.selenium.json.JsonInput;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.reflect.TypeToken;

@Beta
public class CacheStorage {
    public static Command<Void> deleteCache(CacheId cacheId) {
        Objects.requireNonNull(cacheId, "cacheId is required");
        ImmutableMap.Builder<String, CacheId> params = ImmutableMap.builder();
        params.put("cacheId", cacheId);
        return new Command<Void>("CacheStorage.deleteCache", params.build());
    }

    public static Command<Void> deleteEntry(CacheId cacheId, String request) {
        Objects.requireNonNull(cacheId, "cacheId is required");
        Objects.requireNonNull(request, "request is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("cacheId", cacheId);
        params.put("request", request);
        return new Command<Void>("CacheStorage.deleteEntry", params.build());
    }

    public static Command<List<Cache>> requestCacheNames(Optional<String> securityOrigin, Optional<String> storageKey) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        securityOrigin.ifPresent(p -> params.put("securityOrigin", p));
        storageKey.ifPresent(p -> params.put("storageKey", p));
        return new Command<List<Cache>>("CacheStorage.requestCacheNames", params.build(), ConverterFunctions.map("caches", new TypeToken<List<Cache>>(){}.getType()));
    }

    public static Command<CachedResponse> requestCachedResponse(CacheId cacheId, String requestURL, List<Header> requestHeaders) {
        Objects.requireNonNull(cacheId, "cacheId is required");
        Objects.requireNonNull(requestURL, "requestURL is required");
        Objects.requireNonNull(requestHeaders, "requestHeaders is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("cacheId", cacheId);
        params.put("requestURL", requestURL);
        params.put("requestHeaders", requestHeaders);
        return new Command<CachedResponse>("CacheStorage.requestCachedResponse", params.build(), ConverterFunctions.map("response", CachedResponse.class));
    }

    public static Command<RequestEntriesResponse> requestEntries(CacheId cacheId, Optional<Integer> skipCount, Optional<Integer> pageSize, Optional<String> pathFilter) {
        Objects.requireNonNull(cacheId, "cacheId is required");
        ImmutableMap.Builder<String, CacheId> params = ImmutableMap.builder();
        params.put("cacheId", cacheId);
        skipCount.ifPresent(p -> params.put("skipCount", (CacheId)p));
        pageSize.ifPresent(p -> params.put("pageSize", (CacheId)p));
        pathFilter.ifPresent(p -> params.put("pathFilter", (CacheId)p));
        return new Command<RequestEntriesResponse>("CacheStorage.requestEntries", params.build(), input -> (RequestEntriesResponse)input.read((Type)((Object)RequestEntriesResponse.class)));
    }

    public static class RequestEntriesResponse {
        private final List<DataEntry> cacheDataEntries;
        private final Number returnCount;

        public RequestEntriesResponse(List<DataEntry> cacheDataEntries, Number returnCount) {
            this.cacheDataEntries = Objects.requireNonNull(cacheDataEntries, "cacheDataEntries is required");
            this.returnCount = Objects.requireNonNull(returnCount, "returnCount is required");
        }

        public List<DataEntry> getCacheDataEntries() {
            return this.cacheDataEntries;
        }

        public Number getReturnCount() {
            return this.returnCount;
        }

        private static RequestEntriesResponse fromJson(JsonInput input) {
            List cacheDataEntries = null;
            Number returnCount = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "cacheDataEntries": {
                        cacheDataEntries = (List)input.read(new TypeToken<List<DataEntry>>(){}.getType());
                        continue block8;
                    }
                    case "returnCount": {
                        returnCount = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RequestEntriesResponse(cacheDataEntries, returnCount);
        }
    }
}

