/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v111.css.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class PlatformFontUsage {
    private final String familyName;
    private final Boolean isCustomFont;
    private final Number glyphCount;

    public PlatformFontUsage(String familyName, Boolean isCustomFont, Number glyphCount) {
        this.familyName = Objects.requireNonNull(familyName, "familyName is required");
        this.isCustomFont = Objects.requireNonNull(isCustomFont, "isCustomFont is required");
        this.glyphCount = Objects.requireNonNull(glyphCount, "glyphCount is required");
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public Boolean getIsCustomFont() {
        return this.isCustomFont;
    }

    public Number getGlyphCount() {
        return this.glyphCount;
    }

    private static PlatformFontUsage fromJson(JsonInput input) {
        String familyName = null;
        Boolean isCustomFont = false;
        Number glyphCount = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "familyName": {
                    familyName = input.nextString();
                    continue block10;
                }
                case "isCustomFont": {
                    isCustomFont = input.nextBoolean();
                    continue block10;
                }
                case "glyphCount": {
                    glyphCount = input.nextNumber();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PlatformFontUsage(familyName, isCustomFont, glyphCount);
    }
}

