/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v111.tracing.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum StreamFormat {
    JSON("json"),
    PROTO("proto");

    private String value;

    private StreamFormat(String value) {
        this.value = value;
    }

    public static StreamFormat fromString(String s2) {
        return Arrays.stream(StreamFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within StreamFormat "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static StreamFormat fromJson(JsonInput input) {
        return StreamFormat.fromString(input.nextString());
    }
}

