/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.beans.common;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.robotframework.javalib.beans.common.IClassFilter;

public class BasicKeywordFilter
implements IClassFilter {
    private List conditions = new ArrayList();

    public BasicKeywordFilter() {
        this.conditions.add(new PublicClassCondition());
        this.conditions.add(new NotAbstractClassCondition());
        this.conditions.add(new HasDefaultConstructor());
    }

    @Override
    public boolean accept(Class clazz) {
        for (Condition condition : this.conditions) {
            if (condition.check(clazz)) continue;
            return false;
        }
        return true;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    private class HasDefaultConstructor
    implements Condition {
        private HasDefaultConstructor() {
        }

        @Override
        public boolean check(Class clazz) {
            try {
                clazz.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    private class NotAbstractClassCondition
    implements Condition {
        private NotAbstractClassCondition() {
        }

        @Override
        public boolean check(Class clazz) {
            return !Modifier.isAbstract(clazz.getModifiers());
        }
    }

    private class PublicClassCondition
    implements Condition {
        private PublicClassCondition() {
        }

        @Override
        public boolean check(Class clazz) {
            return Modifier.isPublic(clazz.getModifiers());
        }
    }

    public static interface Condition {
        public boolean check(Class var1);
    }
}

