/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.comparison;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.LinkedHashSet;
import java.util.Set;
import ru.yandex.qatools.ashot.Screenshot;
import ru.yandex.qatools.ashot.comparison.DiffMarkupPolicy;
import ru.yandex.qatools.ashot.comparison.ImageDiff;
import ru.yandex.qatools.ashot.comparison.PointsMarkupPolicy;
import ru.yandex.qatools.ashot.coordinates.Coords;
import ru.yandex.qatools.ashot.util.ImageBytesDiffer;
import ru.yandex.qatools.ashot.util.ImageTool;

public class ImageDiffer {
    private static final int DEFAULT_COLOR_DISTORTION = 15;
    private int colorDistortion = 15;
    private DiffMarkupPolicy diffMarkupPolicy = new PointsMarkupPolicy();
    private Color ignoredColor = null;

    public ImageDiffer withIgnoredColor(Color ignoreColor) {
        this.ignoredColor = ignoreColor;
        return this;
    }

    public ImageDiffer withColorDistortion(int distortion) {
        this.colorDistortion = distortion;
        return this;
    }

    public ImageDiffer withDiffMarkupPolicy(DiffMarkupPolicy diffMarkupPolicy) {
        this.diffMarkupPolicy = diffMarkupPolicy;
        return this;
    }

    public ImageDiff makeDiff(Screenshot expected, Screenshot actual) {
        ImageDiff diff = new ImageDiff(this.diffMarkupPolicy);
        if (ImageBytesDiffer.areImagesEqual(expected, actual)) {
            diff.setDiffImage(actual.getImage());
        } else {
            this.markDiffPoints(expected, actual, diff);
        }
        return diff;
    }

    protected void markDiffPoints(Screenshot expected, Screenshot actual, ImageDiff diff) {
        Coords expectedImageCoords = Coords.ofImage(expected.getImage());
        Coords actualImageCoords = Coords.ofImage(actual.getImage());
        CoordsSet compareCoordsSet = new CoordsSet(CoordsSet.union(actual.getCoordsToCompare(), expected.getCoordsToCompare()));
        CoordsSet ignoreCoordsSet = new CoordsSet(CoordsSet.intersection(actual.getIgnoredAreas(), expected.getIgnoredAreas()));
        int width = Math.max(expected.getImage().getWidth(), actual.getImage().getWidth());
        int height = Math.max(expected.getImage().getHeight(), actual.getImage().getHeight());
        diff.setDiffImage(this.createDiffImage(expected.getImage(), actual.getImage(), width, height));
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                if (ignoreCoordsSet.contains(i, j) || this.isInsideBothImages(i, j, expectedImageCoords, actualImageCoords) && (!compareCoordsSet.contains(i, j) || !this.hasDiffInChannel(expected, actual, i, j))) continue;
                diff.addDiffPoint(i, j);
            }
        }
    }

    private boolean hasDiffInChannel(Screenshot expected, Screenshot actual, int i, int j) {
        if (this.ignoredColor != null && ImageTool.rgbCompare(expected.getImage().getRGB(i, j), this.ignoredColor.getRGB(), 0)) {
            return false;
        }
        return !ImageTool.rgbCompare(expected.getImage().getRGB(i, j), actual.getImage().getRGB(i, j), this.colorDistortion);
    }

    public ImageDiff makeDiff(BufferedImage expected, BufferedImage actual) {
        return this.makeDiff(new Screenshot(expected), new Screenshot(actual));
    }

    private BufferedImage createDiffImage(BufferedImage expectedImage, BufferedImage actualImage, int width, int height) {
        BufferedImage diffImage = new BufferedImage(width, height, actualImage.getType());
        this.paintImage(actualImage, diffImage);
        this.paintImage(expectedImage, diffImage);
        return diffImage;
    }

    private void paintImage(BufferedImage image, BufferedImage diffImage) {
        Graphics graphics = diffImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
    }

    private boolean isInsideBothImages(int i, int j, Coords expected, Coords actual) {
        return expected.contains(i, j) && actual.contains(i, j);
    }

    private static class CoordsSet {
        private final boolean isSingle;
        private final Coords minRectangle;
        private Set<Coords> coordsSet;

        public CoordsSet(Set<Coords> coordsSet) {
            this.isSingle = coordsSet.size() == 1;
            this.coordsSet = coordsSet;
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = 0;
            int maxY = 0;
            for (Coords coords : coordsSet) {
                minX = Math.min(minX, (int)coords.getMinX());
                minY = Math.min(minY, (int)coords.getMinY());
                maxX = Math.max(maxX, (int)coords.getMaxX());
                maxY = Math.max(maxY, (int)coords.getMaxY());
            }
            this.minRectangle = new Coords(minX, minY, maxX - minX, maxY - minY);
        }

        private boolean contains(int i, int j) {
            return this.inaccurateContains(i, j) && this.accurateContains(i, j);
        }

        private boolean inaccurateContains(int i, int j) {
            return this.minRectangle.contains(i, j);
        }

        private boolean accurateContains(int i, int j) {
            if (this.isSingle) {
                return true;
            }
            for (Coords coords : this.coordsSet) {
                if (!coords.contains(i, j)) continue;
                return true;
            }
            return false;
        }

        private static Set<Coords> intersection(Set<Coords> coordsPool1, Set<Coords> coordsPool2) {
            return Coords.intersection(coordsPool1, coordsPool2);
        }

        private static Set<Coords> union(Set<Coords> coordsPool1, Set<Coords> coordsPool2) {
            LinkedHashSet<Coords> coordsPool = new LinkedHashSet<Coords>();
            coordsPool.addAll(coordsPool1);
            coordsPool.addAll(coordsPool2);
            return coordsPool;
        }
    }
}

