/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.util.Objects;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityProviderChoice;

public interface SecurityEntityFactory<T> {
    public Class<T> getEntityType();

    public T getInstance(String var1) throws GeneralSecurityException;

    public static <F> SecurityEntityFactory<F> toFactory(Class<F> entityType, SecurityProviderChoice registrar, SecurityProviderChoice defaultProvider) throws ReflectiveOperationException {
        if (registrar == null) {
            if (defaultProvider == null || defaultProvider == SecurityProviderChoice.EMPTY) {
                return SecurityEntityFactory.toDefaultFactory(entityType);
            }
            if (defaultProvider.isNamedProviderUsed()) {
                return SecurityEntityFactory.toNamedProviderFactory(entityType, defaultProvider.getName());
            }
            return SecurityEntityFactory.toProviderInstanceFactory(entityType, defaultProvider.getSecurityProvider());
        }
        if (registrar.isNamedProviderUsed()) {
            return SecurityEntityFactory.toNamedProviderFactory(entityType, registrar.getName());
        }
        return SecurityEntityFactory.toProviderInstanceFactory(entityType, registrar.getSecurityProvider());
    }

    public static <F> SecurityEntityFactory<F> toDefaultFactory(final Class<F> entityType) throws ReflectiveOperationException {
        final Method m3 = entityType.getDeclaredMethod("getInstance", String.class);
        return new SecurityEntityFactory<F>(){
            private final String s;
            {
                this.s = SecurityEntityFactory.class.getSimpleName() + "[" + entityType.getSimpleName() + "][default]";
            }

            @Override
            public Class<F> getEntityType() {
                return entityType;
            }

            @Override
            public F getInstance(String algorithm) throws GeneralSecurityException {
                try {
                    Object value = m3.invoke(null, algorithm);
                    return entityType.cast(value);
                }
                catch (ReflectiveOperationException t) {
                    Throwable e = ExceptionUtils.peelException(t);
                    if (e instanceof GeneralSecurityException) {
                        throw (GeneralSecurityException)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw new GeneralSecurityException(e);
                }
            }

            public String toString() {
                return this.s;
            }
        };
    }

    public static <F> SecurityEntityFactory<F> toNamedProviderFactory(final Class<F> entityType, final String name) throws ReflectiveOperationException {
        ValidateUtils.checkNotNullAndNotEmpty(name, "No provider name specified");
        final Method m3 = entityType.getDeclaredMethod("getInstance", String.class, String.class);
        return new SecurityEntityFactory<F>(){
            private final String s;
            {
                this.s = SecurityEntityFactory.class.getSimpleName() + "[" + entityType.getSimpleName() + "][" + name + "]";
            }

            @Override
            public Class<F> getEntityType() {
                return entityType;
            }

            @Override
            public F getInstance(String algorithm) throws GeneralSecurityException {
                try {
                    Object value = m3.invoke(null, algorithm, name);
                    return entityType.cast(value);
                }
                catch (ReflectiveOperationException t) {
                    Throwable e = ExceptionUtils.peelException(t);
                    if (e instanceof GeneralSecurityException) {
                        throw (GeneralSecurityException)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw new GeneralSecurityException(e);
                }
            }

            public String toString() {
                return this.s;
            }
        };
    }

    public static <F> SecurityEntityFactory<F> toProviderInstanceFactory(final Class<F> entityType, final Provider provider) throws ReflectiveOperationException {
        Objects.requireNonNull(provider, "No provider instance");
        final Method m3 = entityType.getDeclaredMethod("getInstance", String.class, Provider.class);
        return new SecurityEntityFactory<F>(){
            private final String s;
            {
                this.s = SecurityEntityFactory.class.getSimpleName() + "[" + entityType.getSimpleName() + "][" + Provider.class.getSimpleName() + "][" + provider.getName() + "]";
            }

            @Override
            public Class<F> getEntityType() {
                return entityType;
            }

            @Override
            public F getInstance(String algorithm) throws GeneralSecurityException {
                try {
                    Object value = m3.invoke(null, algorithm, provider);
                    return entityType.cast(value);
                }
                catch (ReflectiveOperationException t) {
                    Throwable e = ExceptionUtils.peelException(t);
                    if (e instanceof GeneralSecurityException) {
                        throw (GeneralSecurityException)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw new GeneralSecurityException(e);
                }
            }

            public String toString() {
                return this.s;
            }
        };
    }
}

