/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.timeout;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.io.netty.util.TimerTask;

public abstract class TimeoutTimerTask
implements TimerTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeoutTimerTask.class);
    protected final AtomicBoolean done = new AtomicBoolean();
    protected final NettyRequestSender requestSender;
    final TimeoutsHolder timeoutsHolder;
    volatile NettyResponseFuture<?> nettyResponseFuture;

    TimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder) {
        this.nettyResponseFuture = nettyResponseFuture;
        this.requestSender = requestSender;
        this.timeoutsHolder = timeoutsHolder;
    }

    void expire(String message, long time) {
        LOGGER.debug("{} for {} after {} ms", message, this.nettyResponseFuture, time);
        this.requestSender.abort(this.nettyResponseFuture.channel(), this.nettyResponseFuture, new TimeoutException(message));
    }

    public void clean() {
        if (this.done.compareAndSet(false, true)) {
            this.nettyResponseFuture = null;
        }
    }

    void appendRemoteAddress(StringBuilder sb) {
        InetSocketAddress remoteAddress = this.timeoutsHolder.remoteAddress();
        sb.append(remoteAddress.getHostString());
        if (!remoteAddress.isUnresolved()) {
            sb.append('/').append(remoteAddress.getAddress().getHostAddress());
        }
        sb.append(':').append(remoteAddress.getPort());
    }
}

