/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.math;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ndviet.library.configuration.ConfigurationHelpers;

public class MathHelpers {
    private static final Logger LOGGER = LogManager.getLogger(MathHelpers.class);

    public static String numberDecimalFormat(String input, String decimal, String roundingMode) {
        if (!MathHelpers.isCreatable(input)) {
            LOGGER.error(input + " is not a Number");
            return input;
        }
        Double number = MathHelpers.createNumber(input);
        String string = roundingMode = roundingMode == null ? "" : roundingMode;
        if (decimal != null) {
            RoundingMode rm;
            LOGGER.info("Decimal format is enabled");
            switch (roundingMode) {
                case "HALF_DOWN": {
                    rm = RoundingMode.HALF_DOWN;
                    break;
                }
                default: {
                    rm = RoundingMode.HALF_UP;
                }
            }
            DecimalFormat df = new DecimalFormat(decimal, DecimalFormatSymbols.getInstance(ConfigurationHelpers.getSystemLocale()));
            df.setRoundingMode(rm);
            String returnString = df.format(number);
            LOGGER.info("Decimal format: " + decimal + " - Final result: " + returnString);
            return returnString;
        }
        LOGGER.info("Decimal format is not set");
        return input;
    }

    public static boolean isCreatable(String text) {
        try {
            MathHelpers.createNumber(text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Double createNumber(String text) {
        try {
            NumberFormat format = NumberFormat.getInstance(ConfigurationHelpers.getSystemLocale());
            return format.parse(text).doubleValue();
        }
        catch (ParseException e) {
            throw new RuntimeException("Could not create number");
        }
    }

    public static int compareNumber(String text1, String text2) {
        Double value1 = MathHelpers.createNumber(text1);
        Double value2 = MathHelpers.createNumber(text2);
        return value1.compareTo(value2);
    }
}

