/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import java.io.Closeable;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import org.openqa.selenium.bidi.BiDiSessionStatus;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.Connection;
import org.openqa.selenium.bidi.Event;
import org.openqa.selenium.internal.Require;
import shaded.com.google.common.collect.ImmutableMap;

public class BiDi
implements Closeable {
    private final Duration timeout = Duration.ofSeconds(30L);
    private final Connection connection;
    private final BiDiSessionStatus status;

    public BiDi(Connection connection) {
        this.connection = Require.nonNull("WebSocket connection", connection);
        this.status = (BiDiSessionStatus)this.send(new Command("session.status", Collections.emptyMap(), (Type)((Object)BiDiSessionStatus.class)));
    }

    @Override
    public void close() {
        this.clearListeners();
        this.disconnectSession();
        this.connection.close();
    }

    public void disconnectSession() {
    }

    public <X> X send(Command<X> command) {
        Require.nonNull("Command to send", command);
        return this.connection.sendAndWait(command, this.timeout);
    }

    public <X> void addListener(Event<X> event, Consumer<X> handler) {
        Require.nonNull("Event to listen for", event);
        Require.nonNull("Handler to call", handler);
        this.send(new Command("session.subscribe", ImmutableMap.of("events", Collections.singletonList(event.getMethod()))));
        this.connection.addListener(event, handler);
    }

    <X> void addListener(String browsingContextId, Event<X> event, Consumer<X> handler) {
        Require.nonNull("Event to listen for", event);
        Require.nonNull("Browsing context id", browsingContextId);
        Require.nonNull("Handler to call", handler);
        this.send(new Command("session.subscribe", ImmutableMap.of("contexts", Collections.singletonList(browsingContextId), "events", Collections.singletonList(event.getMethod()))));
        this.connection.addListener(event, handler);
    }

    <X> void addListener(Set<String> browsingContextIds, Event<X> event, Consumer<X> handler) {
        Require.nonNull("List of browsing context ids", browsingContextIds);
        Require.nonNull("Event to listen for", event);
        Require.nonNull("Handler to call", handler);
        this.send(new Command("session.subscribe", ImmutableMap.of("contexts", browsingContextIds, "events", Collections.singletonList(event.getMethod()))));
        this.connection.addListener(event, handler);
    }

    public <X> void clearListener(Event<X> event) {
        Require.nonNull("Event to listen for", event);
        if (this.connection.isEventSubscribed(event)) {
            this.send(new Command("session.unsubscribe", ImmutableMap.of("events", Collections.singletonList(event.getMethod()))));
            this.connection.clearListener(event);
        }
    }

    public void clearListeners() {
        this.connection.clearListeners();
    }

    public BiDiSessionStatus getBidiSessionStatus() {
        return this.status;
    }
}

