/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.webauthn;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v110.webauthn.model.AuthenticatorId;
import org.openqa.selenium.devtools.v110.webauthn.model.Credential;
import org.openqa.selenium.devtools.v110.webauthn.model.CredentialAdded;
import org.openqa.selenium.devtools.v110.webauthn.model.CredentialAsserted;
import org.openqa.selenium.devtools.v110.webauthn.model.VirtualAuthenticatorOptions;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.reflect.TypeToken;

@Beta
public class WebAuthn {
    public static Command<Void> enable(Optional<Boolean> enableUI) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        enableUI.ifPresent(p -> params.put("enableUI", p));
        return new Command<Void>("WebAuthn.enable", params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("WebAuthn.disable", params.build());
    }

    public static Command<AuthenticatorId> addVirtualAuthenticator(VirtualAuthenticatorOptions options) {
        Objects.requireNonNull(options, "options is required");
        ImmutableMap.Builder<String, VirtualAuthenticatorOptions> params = ImmutableMap.builder();
        params.put("options", options);
        return new Command<AuthenticatorId>("WebAuthn.addVirtualAuthenticator", params.build(), ConverterFunctions.map("authenticatorId", AuthenticatorId.class));
    }

    public static Command<Void> setResponseOverrideBits(AuthenticatorId authenticatorId, Optional<Boolean> isBogusSignature, Optional<Boolean> isBadUV, Optional<Boolean> isBadUP) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        ImmutableMap.Builder<String, AuthenticatorId> params = ImmutableMap.builder();
        params.put("authenticatorId", authenticatorId);
        isBogusSignature.ifPresent(p -> params.put("isBogusSignature", (AuthenticatorId)p));
        isBadUV.ifPresent(p -> params.put("isBadUV", (AuthenticatorId)p));
        isBadUP.ifPresent(p -> params.put("isBadUP", (AuthenticatorId)p));
        return new Command<Void>("WebAuthn.setResponseOverrideBits", params.build());
    }

    public static Command<Void> removeVirtualAuthenticator(AuthenticatorId authenticatorId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        ImmutableMap.Builder<String, AuthenticatorId> params = ImmutableMap.builder();
        params.put("authenticatorId", authenticatorId);
        return new Command<Void>("WebAuthn.removeVirtualAuthenticator", params.build());
    }

    public static Command<Void> addCredential(AuthenticatorId authenticatorId, Credential credential) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(credential, "credential is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("authenticatorId", authenticatorId);
        params.put("credential", credential);
        return new Command<Void>("WebAuthn.addCredential", params.build());
    }

    public static Command<Credential> getCredential(AuthenticatorId authenticatorId, String credentialId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(credentialId, "credentialId is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("authenticatorId", authenticatorId);
        params.put("credentialId", credentialId);
        return new Command<Credential>("WebAuthn.getCredential", params.build(), ConverterFunctions.map("credential", Credential.class));
    }

    public static Command<List<Credential>> getCredentials(AuthenticatorId authenticatorId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        ImmutableMap.Builder<String, AuthenticatorId> params = ImmutableMap.builder();
        params.put("authenticatorId", authenticatorId);
        return new Command<List<Credential>>("WebAuthn.getCredentials", params.build(), ConverterFunctions.map("credentials", new TypeToken<List<Credential>>(){}.getType()));
    }

    public static Command<Void> removeCredential(AuthenticatorId authenticatorId, String credentialId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(credentialId, "credentialId is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("authenticatorId", authenticatorId);
        params.put("credentialId", credentialId);
        return new Command<Void>("WebAuthn.removeCredential", params.build());
    }

    public static Command<Void> clearCredentials(AuthenticatorId authenticatorId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        ImmutableMap.Builder<String, AuthenticatorId> params = ImmutableMap.builder();
        params.put("authenticatorId", authenticatorId);
        return new Command<Void>("WebAuthn.clearCredentials", params.build());
    }

    public static Command<Void> setUserVerified(AuthenticatorId authenticatorId, Boolean isUserVerified) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(isUserVerified, "isUserVerified is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("authenticatorId", authenticatorId);
        params.put("isUserVerified", isUserVerified);
        return new Command<Void>("WebAuthn.setUserVerified", params.build());
    }

    public static Command<Void> setAutomaticPresenceSimulation(AuthenticatorId authenticatorId, Boolean enabled) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("authenticatorId", authenticatorId);
        params.put("enabled", enabled);
        return new Command<Void>("WebAuthn.setAutomaticPresenceSimulation", params.build());
    }

    public static Event<CredentialAdded> credentialAdded() {
        return new Event<CredentialAdded>("WebAuthn.credentialAdded", input -> (CredentialAdded)input.read((Type)((Object)CredentialAdded.class)));
    }

    public static Event<CredentialAsserted> credentialAsserted() {
        return new Event<CredentialAsserted>("WebAuthn.credentialAsserted", input -> (CredentialAsserted)input.read((Type)((Object)CredentialAsserted.class)));
    }
}

