/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v111.debugger.model;

import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;
import shaded.com.google.common.reflect.TypeToken;

@Beta
public class WasmDisassemblyChunk {
    private final List<String> lines;
    private final List<Integer> bytecodeOffsets;

    public WasmDisassemblyChunk(List<String> lines, List<Integer> bytecodeOffsets) {
        this.lines = Objects.requireNonNull(lines, "lines is required");
        this.bytecodeOffsets = Objects.requireNonNull(bytecodeOffsets, "bytecodeOffsets is required");
    }

    public List<String> getLines() {
        return this.lines;
    }

    public List<Integer> getBytecodeOffsets() {
        return this.bytecodeOffsets;
    }

    private static WasmDisassemblyChunk fromJson(JsonInput input) {
        List lines = null;
        List bytecodeOffsets = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "lines": {
                    lines = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block8;
                }
                case "bytecodeOffsets": {
                    bytecodeOffsets = (List)input.read(new TypeToken<List<Integer>>(){}.getType());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new WasmDisassemblyChunk(lines, bytecodeOffsets);
    }
}

