/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.performance;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v85.performance.model.Metric;
import org.openqa.selenium.devtools.v85.performance.model.Metrics;
import org.openqa.selenium.json.JsonInput;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.reflect.TypeToken;

public class Performance {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Performance.disable", params.build());
    }

    public static Command<Void> enable(Optional<EnableTimeDomain> timeDomain) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        timeDomain.ifPresent(p -> params.put("timeDomain", p));
        return new Command<Void>("Performance.enable", params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> setTimeDomain(SetTimeDomainTimeDomain timeDomain) {
        Objects.requireNonNull(timeDomain, "timeDomain is required");
        ImmutableMap.Builder<String, SetTimeDomainTimeDomain> params = ImmutableMap.builder();
        params.put("timeDomain", timeDomain);
        return new Command<Void>("Performance.setTimeDomain", params.build());
    }

    public static Command<List<Metric>> getMetrics() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<Metric>>("Performance.getMetrics", params.build(), ConverterFunctions.map("metrics", new TypeToken<List<Metric>>(){}.getType()));
    }

    public static Event<Metrics> metrics() {
        return new Event<Metrics>("Performance.metrics", input -> (Metrics)input.read((Type)((Object)Metrics.class)));
    }

    public static enum SetTimeDomainTimeDomain {
        TIMETICKS("timeTicks"),
        THREADTICKS("threadTicks");

        private String value;

        private SetTimeDomainTimeDomain(String value) {
            this.value = value;
        }

        public static SetTimeDomainTimeDomain fromString(String s2) {
            return Arrays.stream(SetTimeDomainTimeDomain.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within SetTimeDomainTimeDomain "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetTimeDomainTimeDomain fromJson(JsonInput input) {
            return SetTimeDomainTimeDomain.fromString(input.nextString());
        }
    }

    public static enum EnableTimeDomain {
        TIMETICKS("timeTicks"),
        THREADTICKS("threadTicks");

        private String value;

        private EnableTimeDomain(String value) {
            this.value = value;
        }

        public static EnableTimeDomain fromString(String s2) {
            return Arrays.stream(EnableTimeDomain.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within EnableTimeDomain "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static EnableTimeDomain fromJson(JsonInput input) {
            return EnableTimeDomain.fromString(input.nextString());
        }
    }
}

