/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.beans.annotation;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.beans.annotation.IKeywordExtractor;
import org.robotframework.javalib.keyword.DocumentedKeyword;
import org.robotframework.javalib.reflection.IKeywordInvoker;
import org.robotframework.javalib.reflection.KeywordInvoker;

public class AnnotationKeywordExtractor
implements IKeywordExtractor<DocumentedKeyword> {
    @Override
    public Map<String, DocumentedKeyword> extractKeywords(Object keywordBean) {
        HashMap<String, DocumentedKeyword> extractedKeywords = new HashMap<String, DocumentedKeyword>();
        Method[] methods = keywordBean.getClass().getMethods();
        Arrays.sort(methods, (m1, m22) -> -Integer.compare(m1.getParameterCount(), m22.getParameterCount()));
        for (Method method : methods) {
            if (!method.isAnnotationPresent(RobotKeyword.class) && !method.isAnnotationPresent(RobotKeywordOverload.class)) continue;
            this.createOrAddKeyword(extractedKeywords, keywordBean, method);
        }
        return extractedKeywords;
    }

    private void createOrAddKeyword(Map<String, DocumentedKeyword> extractedKeywords, Object keywordBean, Method method) {
        String name = method.getName();
        if (extractedKeywords.containsKey(name)) {
            extractedKeywords.put(name, this.addPolymorphToKeywordDefinition(extractedKeywords.get(name), keywordBean, method));
        } else {
            extractedKeywords.put(name, this.createKeyword(keywordBean, method));
        }
    }

    IKeywordInvoker createKeywordInvoker(Object keywordBean, Method method) {
        return new KeywordInvoker(keywordBean, method);
    }

    private DocumentedKeyword createKeyword(Object keywordBean, Method method) {
        IKeywordInvoker keywordInvoker = this.createKeywordInvoker(keywordBean, method);
        return this.createKeyword(keywordInvoker);
    }

    private DocumentedKeyword createKeyword(final IKeywordInvoker keywordInvoker) {
        return new DocumentedKeyword(){

            @Override
            public Object execute(List arguments, Map kwargs) {
                return keywordInvoker.invoke(arguments, kwargs);
            }

            @Override
            public List<String> getArgumentNames() {
                return keywordInvoker.getParameterNames();
            }

            @Override
            public String getDocumentation() {
                return keywordInvoker.getDocumentation();
            }

            @Override
            public List<String> getArgumentTypes() {
                return keywordInvoker.getParameterTypes();
            }
        };
    }

    private DocumentedKeyword addPolymorphToKeywordDefinition(final DocumentedKeyword original, Object keywordBean, Method method) {
        final DocumentedKeyword other = this.createKeyword(keywordBean, method);
        final boolean isOverload = method.isAnnotationPresent(RobotKeywordOverload.class);
        if (isOverload && method.isAnnotationPresent(RobotKeyword.class)) {
            throw new AssertionError((Object)"Method definition should not have both RobotKeyword and RobotKeywordOverload annotations");
        }
        final int parameterTypesLength = method.getParameterTypes().length;
        return new DocumentedKeyword(){

            @Override
            public Object execute(List arguments, Map kwargs) {
                if (parameterTypesLength == arguments.size()) {
                    return other.execute(arguments, kwargs);
                }
                return original.execute(arguments, kwargs);
            }

            @Override
            public List<String> getArgumentNames() {
                if (isOverload) {
                    return original.getArgumentNames();
                }
                return other.getArgumentNames();
            }

            @Override
            public String getDocumentation() {
                if (isOverload) {
                    return original.getDocumentation();
                }
                return other.getDocumentation();
            }

            @Override
            public List<String> getArgumentTypes() {
                if (isOverload) {
                    return original.getArgumentTypes();
                }
                return other.getArgumentTypes();
            }
        };
    }
}

