/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarantlr4.runtime.debug;

import groovyjarjarantlr4.runtime.RecognitionException;
import groovyjarjarantlr4.runtime.Token;
import groovyjarjarantlr4.runtime.TokenStream;
import groovyjarjarantlr4.runtime.debug.DebugEventListener;
import groovyjarjarantlr4.runtime.tree.TreeAdaptor;

public class DebugTreeAdaptor
implements TreeAdaptor {
    protected DebugEventListener dbg;
    protected TreeAdaptor adaptor;

    public DebugTreeAdaptor(DebugEventListener dbg2, TreeAdaptor adaptor) {
        this.dbg = dbg2;
        this.adaptor = adaptor;
    }

    @Override
    public Object create(Token payload) {
        if (payload.getTokenIndex() < 0) {
            return this.create(payload.getType(), payload.getText());
        }
        Object node = this.adaptor.create(payload);
        this.dbg.createNode(node, payload);
        return node;
    }

    @Override
    public Object errorNode(TokenStream input, Token start, Token stop, RecognitionException e) {
        Object node = this.adaptor.errorNode(input, start, stop, e);
        if (node != null) {
            this.dbg.errorNode(node);
        }
        return node;
    }

    @Override
    public Object dupTree(Object tree) {
        Object t2 = this.adaptor.dupTree(tree);
        this.simulateTreeConstruction(t2);
        return t2;
    }

    protected void simulateTreeConstruction(Object t2) {
        this.dbg.createNode(t2);
        int n = this.adaptor.getChildCount(t2);
        for (int i = 0; i < n; ++i) {
            Object child = this.adaptor.getChild(t2, i);
            this.simulateTreeConstruction(child);
            this.dbg.addChild(t2, child);
        }
    }

    @Override
    public Object dupNode(Object treeNode) {
        Object d = this.adaptor.dupNode(treeNode);
        this.dbg.createNode(d);
        return d;
    }

    @Override
    public Object nil() {
        Object node = this.adaptor.nil();
        this.dbg.nilNode(node);
        return node;
    }

    @Override
    public boolean isNil(Object tree) {
        return this.adaptor.isNil(tree);
    }

    @Override
    public void addChild(Object t2, Object child) {
        if (t2 == null || child == null) {
            return;
        }
        this.adaptor.addChild(t2, child);
        this.dbg.addChild(t2, child);
    }

    @Override
    public Object becomeRoot(Object newRoot, Object oldRoot) {
        Object n = this.adaptor.becomeRoot(newRoot, oldRoot);
        this.dbg.becomeRoot(newRoot, oldRoot);
        return n;
    }

    @Override
    public Object rulePostProcessing(Object root) {
        return this.adaptor.rulePostProcessing(root);
    }

    public void addChild(Object t2, Token child) {
        Object n = this.create(child);
        this.addChild(t2, n);
    }

    @Override
    public Object becomeRoot(Token newRoot, Object oldRoot) {
        Object n = this.create(newRoot);
        this.adaptor.becomeRoot(n, oldRoot);
        this.dbg.becomeRoot(newRoot, oldRoot);
        return n;
    }

    @Override
    public Object create(int tokenType, Token fromToken) {
        Object node = this.adaptor.create(tokenType, fromToken);
        this.dbg.createNode(node);
        return node;
    }

    @Override
    public Object create(int tokenType, Token fromToken, String text) {
        Object node = this.adaptor.create(tokenType, fromToken, text);
        this.dbg.createNode(node);
        return node;
    }

    @Override
    public Object create(int tokenType, String text) {
        Object node = this.adaptor.create(tokenType, text);
        this.dbg.createNode(node);
        return node;
    }

    @Override
    public int getType(Object t2) {
        return this.adaptor.getType(t2);
    }

    @Override
    public void setType(Object t2, int type) {
        this.adaptor.setType(t2, type);
    }

    @Override
    public String getText(Object t2) {
        return this.adaptor.getText(t2);
    }

    @Override
    public void setText(Object t2, String text) {
        this.adaptor.setText(t2, text);
    }

    @Override
    public Token getToken(Object t2) {
        return this.adaptor.getToken(t2);
    }

    @Override
    public void setTokenBoundaries(Object t2, Token startToken, Token stopToken) {
        this.adaptor.setTokenBoundaries(t2, startToken, stopToken);
        if (t2 != null && startToken != null && stopToken != null) {
            this.dbg.setTokenBoundaries(t2, startToken.getTokenIndex(), stopToken.getTokenIndex());
        }
    }

    @Override
    public int getTokenStartIndex(Object t2) {
        return this.adaptor.getTokenStartIndex(t2);
    }

    @Override
    public int getTokenStopIndex(Object t2) {
        return this.adaptor.getTokenStopIndex(t2);
    }

    @Override
    public Object getChild(Object t2, int i) {
        return this.adaptor.getChild(t2, i);
    }

    @Override
    public void setChild(Object t2, int i, Object child) {
        this.adaptor.setChild(t2, i, child);
    }

    @Override
    public Object deleteChild(Object t2, int i) {
        return this.adaptor.deleteChild(t2, i);
    }

    @Override
    public int getChildCount(Object t2) {
        return this.adaptor.getChildCount(t2);
    }

    @Override
    public int getUniqueID(Object node) {
        return this.adaptor.getUniqueID(node);
    }

    @Override
    public Object getParent(Object t2) {
        return this.adaptor.getParent(t2);
    }

    @Override
    public int getChildIndex(Object t2) {
        return this.adaptor.getChildIndex(t2);
    }

    @Override
    public void setParent(Object t2, Object parent) {
        this.adaptor.setParent(t2, parent);
    }

    @Override
    public void setChildIndex(Object t2, int index) {
        this.adaptor.setChildIndex(t2, index);
    }

    @Override
    public void replaceChildren(Object parent, int startChildIndex, int stopChildIndex, Object t2) {
        this.adaptor.replaceChildren(parent, startChildIndex, stopChildIndex, t2);
    }

    public DebugEventListener getDebugListener() {
        return this.dbg;
    }

    public void setDebugListener(DebugEventListener dbg2) {
        this.dbg = dbg2;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }
}

