/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.document.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.doxia.document.DocumentAuthor;
import org.apache.maven.doxia.document.DocumentCover;
import org.apache.maven.doxia.document.DocumentHyperlinkBehaviour;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentStatistic;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.document.DocumentTemplate;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DocumentXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public DocumentXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public DocumentXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s2, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s2, attribute, parser, null);
    }

    private boolean getBooleanValue(String s2, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s2 != null && s2.length() != 0) {
            return Boolean.valueOf(s2);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Byte.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s2, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s2 != null) {
            return s2.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s2, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s2, attribute, null, parser);
    }

    private Date getDateValue(String s2, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s2 != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s2));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s2);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Double.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Float.valueOf(s2).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Integer.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Long.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s2 == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s2;
    }

    private short getShortValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Short.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s2) {
        if (s2 != null) {
            s2 = s2.trim();
        }
        return s2;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public DocumentModel read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read(parser, strict);
    }

    public DocumentModel read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public DocumentModel read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in), strict);
    }

    public DocumentModel read(InputStream in) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in));
    }

    private DocumentAuthor parseDocumentAuthor(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentAuthor documentAuthor = new DocumentAuthor();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "firstName", null, parsed)) {
                documentAuthor.setFirstName(this.interpolatedTrimmed(parser.nextText(), "firstName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lastName", null, parsed)) {
                documentAuthor.setLastName(this.interpolatedTrimmed(parser.nextText(), "lastName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                documentAuthor.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "initials", null, parsed)) {
                documentAuthor.setInitials(this.interpolatedTrimmed(parser.nextText(), "initials"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "title", null, parsed)) {
                documentAuthor.setTitle(this.interpolatedTrimmed(parser.nextText(), "title"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "position", null, parsed)) {
                documentAuthor.setPosition(this.interpolatedTrimmed(parser.nextText(), "position"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "email", null, parsed)) {
                documentAuthor.setEmail(this.interpolatedTrimmed(parser.nextText(), "email"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "phoneNumber", null, parsed)) {
                documentAuthor.setPhoneNumber(this.interpolatedTrimmed(parser.nextText(), "phoneNumber"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "faxNumber", null, parsed)) {
                documentAuthor.setFaxNumber(this.interpolatedTrimmed(parser.nextText(), "faxNumber"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "companyName", null, parsed)) {
                documentAuthor.setCompanyName(this.interpolatedTrimmed(parser.nextText(), "companyName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "street", null, parsed)) {
                documentAuthor.setStreet(this.interpolatedTrimmed(parser.nextText(), "street"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "city", null, parsed)) {
                documentAuthor.setCity(this.interpolatedTrimmed(parser.nextText(), "city"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "postalCode", null, parsed)) {
                documentAuthor.setPostalCode(this.interpolatedTrimmed(parser.nextText(), "postalCode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "country", null, parsed)) {
                documentAuthor.setCountry(this.interpolatedTrimmed(parser.nextText(), "country"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "state", null, parsed)) {
                documentAuthor.setState(this.interpolatedTrimmed(parser.nextText(), "state"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return documentAuthor;
    }

    private DocumentCover parseDocumentCover(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentCover documentCover = new DocumentCover();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "coverTitle", null, parsed)) {
                documentCover.setCoverTitle(this.interpolatedTrimmed(parser.nextText(), "coverTitle"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "coverSubTitle", null, parsed)) {
                documentCover.setCoverSubTitle(this.interpolatedTrimmed(parser.nextText(), "coverSubTitle"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "coverVersion", null, parsed)) {
                documentCover.setCoverVersion(this.interpolatedTrimmed(parser.nextText(), "coverVersion"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "coverType", null, parsed)) {
                documentCover.setCoverType(this.interpolatedTrimmed(parser.nextText(), "coverType"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "coverDate", null, parsed)) {
                String dateFormat = null;
                documentCover.setCoverDate(this.getDateValue(this.interpolatedTrimmed(parser.nextText(), "coverDate"), "coverDate", dateFormat, parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "coverdate", null, parsed)) {
                documentCover.setCoverdate(this.interpolatedTrimmed(parser.nextText(), "coverdate"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "authors", null, parsed)) {
                ArrayList<DocumentAuthor> authors = new ArrayList<DocumentAuthor>();
                documentCover.setAuthors(authors);
                while (parser.nextTag() == 2) {
                    if ("author".equals(parser.getName())) {
                        authors.add(this.parseDocumentAuthor(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "author", null, parsed)) {
                documentCover.setAuthor(this.interpolatedTrimmed(parser.nextText(), "author"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "projectName", null, parsed)) {
                documentCover.setProjectName(this.interpolatedTrimmed(parser.nextText(), "projectName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "projectLogo", null, parsed)) {
                documentCover.setProjectLogo(this.interpolatedTrimmed(parser.nextText(), "projectLogo"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "companyName", null, parsed)) {
                documentCover.setCompanyName(this.interpolatedTrimmed(parser.nextText(), "companyName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "companyLogo", null, parsed)) {
                documentCover.setCompanyLogo(this.interpolatedTrimmed(parser.nextText(), "companyLogo"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return documentCover;
    }

    private DocumentHyperlinkBehaviour parseDocumentHyperlinkBehaviour(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentHyperlinkBehaviour documentHyperlinkBehaviour = new DocumentHyperlinkBehaviour();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("targetFrame".equals(name)) {
                documentHyperlinkBehaviour.setTargetFrame(this.interpolatedTrimmed(value, "targetFrame"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return documentHyperlinkBehaviour;
    }

    private DocumentMeta parseDocumentMeta(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentMeta documentMeta = new DocumentMeta();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String dateFormat;
            if (this.checkFieldWithDuplicate(parser, "title", null, parsed)) {
                documentMeta.setTitle(this.interpolatedTrimmed(parser.nextText(), "title"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "author", null, parsed)) {
                documentMeta.setAuthor(this.interpolatedTrimmed(parser.nextText(), "author"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "authors", null, parsed)) {
                ArrayList<DocumentAuthor> authors = new ArrayList<DocumentAuthor>();
                documentMeta.setAuthors(authors);
                while (parser.nextTag() == 2) {
                    if ("author".equals(parser.getName())) {
                        authors.add(this.parseDocumentAuthor(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "subject", null, parsed)) {
                documentMeta.setSubject(this.interpolatedTrimmed(parser.nextText(), "subject"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "keywords", null, parsed)) {
                documentMeta.setKeywords(this.interpolatedTrimmed(parser.nextText(), "keywords"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "keyWords", null, parsed)) {
                ArrayList<String> keyWords = new ArrayList<String>();
                documentMeta.setKeyWords(keyWords);
                while (parser.nextTag() == 2) {
                    if ("keyWord".equals(parser.getName())) {
                        keyWords.add(this.interpolatedTrimmed(parser.nextText(), "keyWords"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pageSize", null, parsed)) {
                documentMeta.setPageSize(this.interpolatedTrimmed(parser.nextText(), "pageSize"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "generator", null, parsed)) {
                documentMeta.setGenerator(this.interpolatedTrimmed(parser.nextText(), "generator"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "description", null, parsed)) {
                documentMeta.setDescription(this.interpolatedTrimmed(parser.nextText(), "description"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "initialCreator", null, parsed)) {
                documentMeta.setInitialCreator(this.interpolatedTrimmed(parser.nextText(), "initialCreator"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "creator", null, parsed)) {
                documentMeta.setCreator(this.interpolatedTrimmed(parser.nextText(), "creator"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "printedBy", null, parsed)) {
                documentMeta.setPrintedBy(this.interpolatedTrimmed(parser.nextText(), "printedBy"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "creationDate", null, parsed)) {
                dateFormat = null;
                documentMeta.setCreationDate(this.getDateValue(this.interpolatedTrimmed(parser.nextText(), "creationDate"), "creationDate", dateFormat, parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "creationdate", null, parsed)) {
                documentMeta.setCreationdate(this.interpolatedTrimmed(parser.nextText(), "creationdate"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "date", null, parsed)) {
                dateFormat = null;
                documentMeta.setDate(this.getDateValue(this.interpolatedTrimmed(parser.nextText(), "date"), "date", dateFormat, parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "modifydate", null, parsed)) {
                documentMeta.setModifydate(this.interpolatedTrimmed(parser.nextText(), "modifydate"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "printDate", null, parsed)) {
                dateFormat = null;
                documentMeta.setPrintDate(this.getDateValue(this.interpolatedTrimmed(parser.nextText(), "printDate"), "printDate", dateFormat, parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "printdate", null, parsed)) {
                documentMeta.setPrintdate(this.interpolatedTrimmed(parser.nextText(), "printdate"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "template", null, parsed)) {
                documentMeta.setTemplate(this.parseDocumentTemplate(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "hyperlinkBehaviour", null, parsed)) {
                documentMeta.setHyperlinkBehaviour(this.parseDocumentHyperlinkBehaviour(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "language", null, parsed)) {
                documentMeta.setLanguage(this.interpolatedTrimmed(parser.nextText(), "language"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "editingCycles", null, parsed)) {
                documentMeta.setEditingCycles(this.getLongValue(this.interpolatedTrimmed(parser.nextText(), "editingCycles"), "editingCycles", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "editingDuration", null, parsed)) {
                documentMeta.setEditingDuration(this.getLongValue(this.interpolatedTrimmed(parser.nextText(), "editingDuration"), "editingDuration", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "documentStatistic", null, parsed)) {
                documentMeta.setDocumentStatistic(this.parseDocumentStatistic(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "confidential", null, parsed)) {
                documentMeta.setConfidential(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "confidential"), "confidential", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "draft", null, parsed)) {
                documentMeta.setDraft(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "draft"), "draft", parser, "false"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return documentMeta;
    }

    private DocumentModel parseDocumentModel(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentModel documentModel = new DocumentModel();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            if ("outputName".equals(name)) {
                documentModel.setOutputName(this.interpolatedTrimmed(value, "outputName"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "meta", null, parsed)) {
                documentModel.setMeta(this.parseDocumentMeta(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "toc", null, parsed)) {
                documentModel.setToc(this.parseDocumentTOC(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "cover", null, parsed)) {
                documentModel.setCover(this.parseDocumentCover(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return documentModel;
    }

    private DocumentStatistic parseDocumentStatistic(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentStatistic documentStatistic = new DocumentStatistic();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("pageCount".equals(name)) {
                documentStatistic.setPageCount(this.getLongValue(this.interpolatedTrimmed(value, "pageCount"), "pageCount", parser, strict));
                continue;
            }
            if ("tableCount".equals(name)) {
                documentStatistic.setTableCount(this.getLongValue(this.interpolatedTrimmed(value, "tableCount"), "tableCount", parser, strict));
                continue;
            }
            if ("drawCount".equals(name)) {
                documentStatistic.setDrawCount(this.getLongValue(this.interpolatedTrimmed(value, "drawCount"), "drawCount", parser, strict));
                continue;
            }
            if ("imageCount".equals(name)) {
                documentStatistic.setImageCount(this.getLongValue(this.interpolatedTrimmed(value, "imageCount"), "imageCount", parser, strict));
                continue;
            }
            if ("objectCount".equals(name)) {
                documentStatistic.setObjectCount(this.getLongValue(this.interpolatedTrimmed(value, "objectCount"), "objectCount", parser, strict));
                continue;
            }
            if ("oleObjectCount".equals(name)) {
                documentStatistic.setOleObjectCount(this.getLongValue(this.interpolatedTrimmed(value, "oleObjectCount"), "oleObjectCount", parser, strict));
                continue;
            }
            if ("paragraphCount".equals(name)) {
                documentStatistic.setParagraphCount(this.getLongValue(this.interpolatedTrimmed(value, "paragraphCount"), "paragraphCount", parser, strict));
                continue;
            }
            if ("wordCount".equals(name)) {
                documentStatistic.setWordCount(this.getLongValue(this.interpolatedTrimmed(value, "wordCount"), "wordCount", parser, strict));
                continue;
            }
            if ("characterCount".equals(name)) {
                documentStatistic.setCharacterCount(this.getLongValue(this.interpolatedTrimmed(value, "characterCount"), "characterCount", parser, strict));
                continue;
            }
            if ("rowCount".equals(name)) {
                documentStatistic.setRowCount(this.getLongValue(this.interpolatedTrimmed(value, "rowCount"), "rowCount", parser, strict));
                continue;
            }
            if ("frameCount".equals(name)) {
                documentStatistic.setFrameCount(this.getLongValue(this.interpolatedTrimmed(value, "frameCount"), "frameCount", parser, strict));
                continue;
            }
            if ("sentenceCount".equals(name)) {
                documentStatistic.setSentenceCount(this.getLongValue(this.interpolatedTrimmed(value, "sentenceCount"), "sentenceCount", parser, strict));
                continue;
            }
            if ("syllableCount".equals(name)) {
                documentStatistic.setSyllableCount(this.getLongValue(this.interpolatedTrimmed(value, "syllableCount"), "syllableCount", parser, strict));
                continue;
            }
            if ("nonWhitespaceCharacterCount".equals(name)) {
                documentStatistic.setNonWhitespaceCharacterCount(this.getLongValue(this.interpolatedTrimmed(value, "nonWhitespaceCharacterCount"), "nonWhitespaceCharacterCount", parser, strict));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return documentStatistic;
    }

    private DocumentTOC parseDocumentTOC(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentTOC documentTOC = new DocumentTOC();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                documentTOC.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("depth".equals(name)) {
                documentTOC.setDepth(this.getIntegerValue(this.interpolatedTrimmed(value, "depth"), "depth", parser, strict));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if ("item".equals(parser.getName())) {
                List<DocumentTOCItem> items = documentTOC.getItems();
                if (items == null) {
                    items = new ArrayList<DocumentTOCItem>();
                    documentTOC.setItems(items);
                }
                items.add(this.parseDocumentTOCItem(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return documentTOC;
    }

    private DocumentTOCItem parseDocumentTOCItem(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentTOCItem documentTOCItem = new DocumentTOCItem();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                documentTOCItem.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("ref".equals(name)) {
                documentTOCItem.setRef(this.interpolatedTrimmed(value, "ref"));
                continue;
            }
            if ("collapse".equals(name)) {
                documentTOCItem.setCollapse(this.getBooleanValue(this.interpolatedTrimmed(value, "collapse"), "collapse", parser, "false"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if ("item".equals(parser.getName())) {
                List<DocumentTOCItem> items = documentTOCItem.getItems();
                if (items == null) {
                    items = new ArrayList<DocumentTOCItem>();
                    documentTOCItem.setItems(items);
                }
                items.add(this.parseDocumentTOCItem(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return documentTOCItem;
    }

    private DocumentTemplate parseDocumentTemplate(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DocumentTemplate documentTemplate = new DocumentTemplate();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("href".equals(name)) {
                documentTemplate.setHref(this.interpolatedTrimmed(value, "href"));
                continue;
            }
            if ("title".equals(name)) {
                documentTemplate.setTitle(this.interpolatedTrimmed(value, "title"));
                continue;
            }
            if ("date".equals(name)) {
                String dateFormat = null;
                documentTemplate.setDate(this.getDateValue(this.interpolatedTrimmed(value, "date"), "date", dateFormat, parser));
                continue;
            }
            if ("modifydate".equals(name)) {
                documentTemplate.setModifydate(this.interpolatedTrimmed(value, "modifydate"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return documentTemplate;
    }

    private DocumentModel read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        DocumentModel documentModel = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"document".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'document' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'document'", parser, null);
                }
                documentModel = this.parseDocumentModel(parser, strict);
                documentModel.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return documentModel;
        }
        throw new XmlPullParserException("Expected root element 'document' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

