/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xhtml5;

import java.io.Writer;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.module.xhtml5.Xhtml5Markup;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.impl.SinkUtils;
import org.apache.maven.doxia.sink.impl.Xhtml5BaseSink;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

public class Xhtml5Sink
extends Xhtml5BaseSink
implements Xhtml5Markup {
    private String encoding;
    private String languageId;
    private boolean headTitleFlag;

    protected Xhtml5Sink(Writer writer) {
        super(writer);
    }

    protected Xhtml5Sink(Writer writer, String encoding) {
        super(writer);
        this.encoding = encoding;
    }

    protected Xhtml5Sink(Writer writer, String encoding, String languageId) {
        this(writer, encoding);
        this.languageId = languageId;
    }

    @Override
    public void head() {
        this.init();
        this.setHeadFlag(true);
        this.write("<!DOCTYPE html>");
        SinkEventAttributeSet atts = new SinkEventAttributeSet();
        atts.addAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        if (this.languageId != null) {
            atts.addAttribute(HTML.Attribute.LANG.toString(), this.languageId);
            atts.addAttribute("xml:lang", this.languageId);
        }
        this.writeStartTag(HTML, atts);
        this.writeStartTag(HEAD);
    }

    @Override
    public void head_() {
        if (!this.isHeadTitleFlag()) {
            this.writeStartTag(TITLE);
            this.writeEndTag(TITLE);
        }
        this.setHeadFlag(false);
        this.setHeadTitleFlag(false);
        if (this.encoding != null) {
            this.write("<meta charset=\"" + this.encoding + "\"/>");
        }
        this.writeEndTag(HEAD);
    }

    @Override
    public void title() {
        this.setHeadTitleFlag(true);
        this.writeStartTag(TITLE);
    }

    @Override
    public void title_() {
        this.content(this.getTextBuffer().toString());
        this.writeEndTag(TITLE);
        this.resetTextBuffer();
    }

    @Override
    public void author_() {
        if (this.getTextBuffer().length() > 0) {
            SinkEventAttributeSet att = new SinkEventAttributeSet();
            att.addAttribute(HTML.Attribute.NAME, "author");
            String text = HtmlTools.escapeHTML(this.getTextBuffer().toString());
            text = StringUtils.replace(text, "&amp;#", "&#");
            att.addAttribute(HTML.Attribute.CONTENT, text);
            this.writeSimpleTag(META, att);
            this.resetTextBuffer();
        }
    }

    @Override
    public void date_() {
        if (this.getTextBuffer().length() > 0) {
            SinkEventAttributeSet att = new SinkEventAttributeSet();
            att.addAttribute(HTML.Attribute.NAME, "date");
            att.addAttribute(HTML.Attribute.CONTENT, this.getTextBuffer().toString());
            this.writeSimpleTag(META, att);
            this.resetTextBuffer();
        }
    }

    @Override
    public void body() {
        this.writeStartTag(BODY);
    }

    @Override
    public void body_() {
        this.writeEndTag(BODY);
        this.writeEndTag(HTML);
        this.flush();
        this.init();
    }

    @Override
    protected void onSection(int depth, SinkEventAttributes attributes) {
        if (depth >= 1 && depth <= 5) {
            SinkEventAttributeSet att = new SinkEventAttributeSet();
            att.addAttributes(SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES));
            this.writeStartTag(HtmlMarkup.SECTION, att);
        }
    }

    @Override
    protected void onSection_(int depth) {
        if (depth >= 1 && depth <= 5) {
            this.writeEndTag(HtmlMarkup.SECTION);
        }
    }

    @Override
    protected void onSectionTitle(int depth, SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        if (depth == 1) {
            this.writeStartTag(HtmlMarkup.H2, atts);
        } else if (depth == 2) {
            this.writeStartTag(HtmlMarkup.H3, atts);
        } else if (depth == 3) {
            this.writeStartTag(HtmlMarkup.H4, atts);
        } else if (depth == 4) {
            this.writeStartTag(HtmlMarkup.H5, atts);
        } else if (depth == 5) {
            this.writeStartTag(HtmlMarkup.H6, atts);
        }
    }

    @Override
    protected void onSectionTitle_(int depth) {
        if (depth == 1) {
            this.writeEndTag(HtmlMarkup.H2);
        } else if (depth == 2) {
            this.writeEndTag(HtmlMarkup.H3);
        } else if (depth == 3) {
            this.writeEndTag(HtmlMarkup.H4);
        } else if (depth == 4) {
            this.writeEndTag(HtmlMarkup.H5);
        } else if (depth == 5) {
            this.writeEndTag(HtmlMarkup.H6);
        }
    }

    protected void setHeadTitleFlag(boolean headTitleFlag) {
        this.headTitleFlag = headTitleFlag;
    }

    protected boolean isHeadTitleFlag() {
        return this.headTitleFlag;
    }
}

