/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.parser;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.markup.XmlMarkup;
import org.apache.maven.doxia.parser.AbstractParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.util.HtmlTools;
import org.apache.maven.doxia.util.XmlValidator;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractXmlParser
extends AbstractParser
implements XmlMarkup {
    private static final Pattern PATTERN_ENTITY_1 = Pattern.compile("<!ENTITY(\\s)+([^>|^\\s]+)(\\s)+\"(\\s)*(&[a-zA-Z]{2,6};)(\\s)*\"(\\s)*>");
    private static final Pattern PATTERN_ENTITY_2 = Pattern.compile("<!ENTITY(\\s)+([^>|^\\s]+)(\\s)+\"(\\s)*(&(#x?[0-9a-fA-F]{1,5};)*)(\\s)*\"(\\s)*>");
    private boolean ignorableWhitespace;
    private boolean collapsibleWhitespace;
    private boolean trimmableWhitespace;
    private Map<String, String> entities;
    private boolean validate = false;

    @Override
    public void parse(Reader source, Sink sink, String reference) throws ParseException {
        this.init();
        Reader src = source;
        if (this.isValidate()) {
            String content;
            try {
                content = IOUtil.toString(new BufferedReader(src));
            }
            catch (IOException e) {
                throw new ParseException("Error reading the model: " + e.getMessage(), e);
            }
            new XmlValidator(this.getLog()).validate(content);
            src = new StringReader(content);
        }
        try {
            MXParser parser = new MXParser();
            parser.setInput(src);
            this.initXmlParser(parser);
            sink.enableLogging(this.getLog());
            this.parseXml(parser, sink);
        }
        catch (XmlPullParserException ex) {
            throw new ParseException("Error parsing the model: " + ex.getMessage(), ex, ex.getLineNumber(), ex.getColumnNumber());
        }
        catch (MacroExecutionException ex) {
            throw new ParseException("Macro execution failed: " + ex.getMessage(), ex);
        }
        this.setSecondParsing(false);
        this.init();
    }

    protected void initXmlParser(XmlPullParser parser) throws XmlPullParserException {
    }

    @Override
    public final int getType() {
        return 2;
    }

    protected SinkEventAttributeSet getAttributesFromParser(XmlPullParser parser) {
        int count = parser.getAttributeCount();
        if (count < 0) {
            return null;
        }
        SinkEventAttributeSet atts = new SinkEventAttributeSet(count);
        for (int i = 0; i < count; ++i) {
            atts.addAttribute(parser.getAttributeName(i), parser.getAttributeValue(i));
        }
        return atts;
    }

    private void parseXml(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                this.handleStartTag(parser, sink);
            } else if (eventType == 3) {
                this.handleEndTag(parser, sink);
            } else if (eventType == 4) {
                String text = this.getText(parser);
                if (this.isIgnorableWhitespace()) {
                    if (text.trim().length() != 0) {
                        this.handleText(parser, sink);
                    }
                } else {
                    this.handleText(parser, sink);
                }
            } else if (eventType == 5) {
                this.handleCdsect(parser, sink);
            } else if (eventType == 9) {
                this.handleComment(parser, sink);
            } else if (eventType == 6) {
                this.handleEntity(parser, sink);
            } else if (eventType != 7 && eventType != 8 && eventType == 10) {
                this.addLocalEntities(parser, parser.getText());
                for (byte[] res : CachedFileEntityResolver.ENTITY_CACHE.values()) {
                    this.addDTDEntities(parser, new String(res));
                }
            }
            try {
                eventType = parser.nextToken();
            }
            catch (IOException io) {
                throw new XmlPullParserException("IOException: " + io.getMessage(), parser, io);
            }
        }
    }

    protected abstract void handleStartTag(XmlPullParser var1, Sink var2) throws XmlPullParserException, MacroExecutionException;

    protected abstract void handleEndTag(XmlPullParser var1, Sink var2) throws XmlPullParserException, MacroExecutionException;

    protected void handleText(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if (StringUtils.isNotEmpty(text)) {
            sink.text(text);
        }
    }

    protected void handleCdsect(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        sink.text(this.getText(parser));
    }

    protected void handleComment(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        if (this.isEmitComments()) {
            sink.comment(this.getText(parser));
        }
    }

    protected void handleEntity(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        String name = parser.getName();
        if ("#160".equals(name) || "nbsp".equals(name) || "#x00A0".equals(name)) {
            sink.nonBreakingSpace();
        } else {
            String unescaped = HtmlTools.unescapeHTML(text);
            sink.text(unescaped);
        }
    }

    protected void handleUnknown(XmlPullParser parser, Sink sink, int type) {
        Object[] required = new Object[]{type};
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        sink.unknown(parser.getName(), required, attribs);
    }

    protected boolean isIgnorableWhitespace() {
        return this.ignorableWhitespace;
    }

    protected void setIgnorableWhitespace(boolean ignorable) {
        this.ignorableWhitespace = ignorable;
    }

    protected boolean isCollapsibleWhitespace() {
        return this.collapsibleWhitespace;
    }

    protected void setCollapsibleWhitespace(boolean collapsible) {
        this.collapsibleWhitespace = collapsible;
    }

    protected boolean isTrimmableWhitespace() {
        return this.trimmableWhitespace;
    }

    protected void setTrimmableWhitespace(boolean trimmable) {
        this.trimmableWhitespace = trimmable;
    }

    protected String getText(XmlPullParser parser) {
        String text = parser.getText();
        if (this.isTrimmableWhitespace()) {
            text = text.trim();
        }
        if (this.isCollapsibleWhitespace()) {
            StringBuilder newText = new StringBuilder();
            String[] elts = StringUtils.split(text, " \r\n");
            for (int i = 0; i < elts.length; ++i) {
                newText.append(elts[i]);
                if (i + 1 >= elts.length) continue;
                newText.append(" ");
            }
            text = newText.toString();
        }
        return text;
    }

    protected Map<String, String> getLocalEntities() {
        if (this.entities == null) {
            this.entities = new LinkedHashMap<String, String>();
        }
        return this.entities;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    private void addEntity(XmlPullParser parser, String entityName, String entityValue) throws XmlPullParserException {
        if (entityName.endsWith("amp") || entityName.endsWith("lt") || entityName.endsWith("gt") || entityName.endsWith("quot") || entityName.endsWith("apos")) {
            return;
        }
        parser.defineEntityReplacementText(entityName, entityValue);
        this.getLocalEntities().put(entityName, entityValue);
    }

    private void addLocalEntities(XmlPullParser parser, String text) throws XmlPullParserException {
        int entitiesCount = StringUtils.countMatches(text, "<!ENTITY");
        if (entitiesCount > 0) {
            int start = text.indexOf(91);
            int end = text.lastIndexOf(93);
            if (start != -1 && end != -1) {
                this.addDTDEntities(parser, text.substring(start + 1, end));
            }
        }
    }

    private void addDTDEntities(XmlPullParser parser, String text) throws XmlPullParserException {
        int entitiesCount = StringUtils.countMatches(text, "<!ENTITY");
        if (entitiesCount > 0) {
            String txt = StringUtils.replace(text, "<!ENTITY", "\n<!ENTITY");
            try (BufferedReader reader = new BufferedReader(new StringReader(txt));){
                String line;
                String tmpLine = "";
                while ((line = reader.readLine()) != null) {
                    String entityValue;
                    String entityName;
                    Matcher matcher = PATTERN_ENTITY_1.matcher(tmpLine = tmpLine + "\n" + line);
                    if (matcher.find() && matcher.groupCount() == 7) {
                        entityName = matcher.group(2);
                        entityValue = matcher.group(5);
                        this.addEntity(parser, entityName, entityValue);
                        tmpLine = "";
                        continue;
                    }
                    matcher = PATTERN_ENTITY_2.matcher(tmpLine);
                    if (!matcher.find() || matcher.groupCount() != 8) continue;
                    entityName = matcher.group(2);
                    entityValue = matcher.group(5);
                    this.addEntity(parser, entityName, entityValue);
                    tmpLine = "";
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class CachedFileEntityResolver
    implements EntityResolver {
        protected static final Map<String, byte[]> ENTITY_CACHE = new Hashtable<String, byte[]>();

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            byte[] res = ENTITY_CACHE.get(systemId);
            if (res == null) {
                String systemName = FileUtils.getFile(systemId).getName();
                File temp = new File(System.getProperty("java.io.tmpdir"), systemName);
                if (!temp.exists()) {
                    if (systemId.toLowerCase(Locale.ENGLISH).startsWith("file")) {
                        String resource = "/" + systemName;
                        URL url = this.getClass().getResource(resource);
                        if (url == null) throw new SAXException("Could not find the SYSTEM entity: " + systemId + " because '" + resource + "' is not available of the classpath.");
                        res = CachedFileEntityResolver.toByteArray(url);
                    } else {
                        res = CachedFileEntityResolver.toByteArray(new URL(systemId));
                    }
                    this.copy(res, temp);
                } else {
                    res = CachedFileEntityResolver.toByteArray(temp.toURI().toURL());
                }
                ENTITY_CACHE.put(systemId, res);
            }
            InputSource is = new InputSource(new ByteArrayInputStream(res));
            is.setPublicId(publicId);
            is.setSystemId(systemId);
            return is;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static byte[] toByteArray(URL url) throws SAXException {
            if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
                InputStream is = null;
                try {
                    is = url.openStream();
                    if (is == null) {
                        throw new SAXException("Cannot open stream from the url: " + url.toString());
                    }
                    byte[] byArray = IOUtil.toByteArray(is);
                    return byArray;
                }
                catch (IOException e) {
                    throw new SAXException("IOException: " + e.getMessage(), e);
                }
                finally {
                    IOUtil.close(is);
                }
            }
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().useSystemProperties().setRetryHandler(new DefaultHttpRequestRetryHandler(3, false)).setUserAgent("Apache-Doxia/" + AbstractParser.doxiaVersion());
            try (CloseableHttpResponse response = httpClientBuilder.build().execute(new HttpGet(url.toString()));){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new IOException("The status code when accessing the URL '" + url.toString() + "' was " + statusCode + ", which is not allowed. The server gave this reason for the failure '" + response.getStatusLine().getReasonPhrase() + "'.");
                }
                byte[] byArray = EntityUtils.toByteArray(response.getEntity());
                return byArray;
            }
            catch (ClientProtocolException e) {
                throw new SAXException("ClientProtocolException: Fatal protocol violation: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new SAXException("IOException: Fatal transport error: " + e.getMessage(), e);
            }
        }

        private void copy(byte[] res, File f) throws SAXException {
            if (f.isDirectory()) {
                throw new SAXException("'" + f.getAbsolutePath() + "' is a directory, can not write it.");
            }
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(f);
                IOUtil.copy(res, (OutputStream)os);
            }
            catch (IOException e) {
                try {
                    throw new SAXException("IOException: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(os);
                    throw throwable;
                }
            }
            IOUtil.close(os);
        }
    }
}

