/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.parser;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.parser.AbstractXmlParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class Xhtml5BaseParser
extends AbstractXmlParser
implements HtmlMarkup {
    private boolean scriptBlock;
    private boolean isLink;
    private boolean isAnchor;
    private int orderedListDepth = 0;
    private int sectionLevel;
    private int headingLevel;
    private boolean inVerbatim;
    private Stack<String> divStack = new Stack();
    boolean hasDefinitionListItem = false;
    private Map<String, Set<String>> warnMessages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(Reader source, Sink sink, String reference) throws ParseException {
        this.init();
        try {
            super.parse(source, sink, reference);
        }
        finally {
            this.logWarnings();
            this.setSecondParsing(false);
            this.init();
        }
    }

    @Override
    protected void initXmlParser(XmlPullParser parser) throws XmlPullParserException {
        super.initXmlParser(parser);
    }

    protected boolean baseStartTag(XmlPullParser parser, Sink sink) {
        boolean visited = true;
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        if (parser.getName().equals(HtmlMarkup.ARTICLE.toString())) {
            sink.article(attribs);
        } else if (parser.getName().equals(HtmlMarkup.NAV.toString())) {
            sink.navigation(attribs);
        } else if (parser.getName().equals(HtmlMarkup.ASIDE.toString())) {
            sink.sidebar(attribs);
        } else if (parser.getName().equals(HtmlMarkup.SECTION.toString())) {
            this.handleSectionStart(sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.H2.toString())) {
            this.handleHeadingStart(sink, 1, attribs);
        } else if (parser.getName().equals(HtmlMarkup.H3.toString())) {
            this.handleHeadingStart(sink, 2, attribs);
        } else if (parser.getName().equals(HtmlMarkup.H4.toString())) {
            this.handleHeadingStart(sink, 3, attribs);
        } else if (parser.getName().equals(HtmlMarkup.H5.toString())) {
            this.handleHeadingStart(sink, 4, attribs);
        } else if (parser.getName().equals(HtmlMarkup.H6.toString())) {
            this.handleHeadingStart(sink, 5, attribs);
        } else if (parser.getName().equals(HtmlMarkup.HEADER.toString())) {
            sink.header(attribs);
        } else if (parser.getName().equals(HtmlMarkup.MAIN.toString())) {
            sink.content(attribs);
        } else if (parser.getName().equals(HtmlMarkup.FOOTER.toString())) {
            sink.footer(attribs);
        } else if (parser.getName().equals(HtmlMarkup.EM.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.EMPHASIS);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.STRONG.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.STRONG);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.SMALL.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.SMALL);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.S.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.LINE_THROUGH);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.CITE.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.CITATION);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.Q.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.QUOTE);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.DFN.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.DEFINITION);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.ABBR.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.ABBREVIATION);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.I.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.ITALIC);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.B.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.BOLD);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.CODE.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.CODE);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.VAR.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.VARIABLE);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.SAMP.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.SAMPLE);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.KBD.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.KEYBOARD);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.SUP.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.SUPERSCRIPT);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.SUB.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.SUBSCRIPT);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.U.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.ANNOTATION);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.MARK.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.HIGHLIGHT);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.RUBY.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.RUBY);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.RB.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.RUBY_BASE);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.RT.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.RUBY_TEXT);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.RTC.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.RUBY_TEXT_CONTAINER);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.RP.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.RUBY_PARANTHESES);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.BDI.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.BIDIRECTIONAL_ISOLATION);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.BDO.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.BIDIRECTIONAL_OVERRIDE);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.SPAN.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.PHRASE);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.INS.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.INSERT);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.DEL.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.DELETE);
            sink.inline(attribs);
        } else if (parser.getName().equals(HtmlMarkup.P.toString())) {
            this.handlePStart(sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.DIV.toString())) {
            this.handleDivStart(parser, attribs, sink);
        } else if (parser.getName().equals(HtmlMarkup.PRE.toString())) {
            this.handlePreStart(attribs, sink);
        } else if (parser.getName().equals(HtmlMarkup.UL.toString())) {
            sink.list(attribs);
        } else if (parser.getName().equals(HtmlMarkup.OL.toString())) {
            this.handleOLStart(parser, sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.LI.toString())) {
            this.handleLIStart(sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.DL.toString())) {
            sink.definitionList(attribs);
        } else if (parser.getName().equals(HtmlMarkup.DT.toString())) {
            if (this.hasDefinitionListItem) {
                sink.definitionListItem_();
            }
            sink.definitionListItem(attribs);
            this.hasDefinitionListItem = true;
            sink.definedTerm(attribs);
        } else if (parser.getName().equals(HtmlMarkup.DD.toString())) {
            if (!this.hasDefinitionListItem) {
                sink.definitionListItem(attribs);
            }
            sink.definition(attribs);
        } else if (parser.getName().equals(HtmlMarkup.FIGURE.toString())) {
            sink.figure(attribs);
        } else if (parser.getName().equals(HtmlMarkup.FIGCAPTION.toString())) {
            sink.figureCaption(attribs);
        } else if (parser.getName().equals(HtmlMarkup.A.toString())) {
            this.handleAStart(parser, sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.TABLE.toString())) {
            this.handleTableStart(sink, attribs, parser);
        } else if (parser.getName().equals(HtmlMarkup.TR.toString())) {
            sink.tableRow(attribs);
        } else if (parser.getName().equals(HtmlMarkup.TH.toString())) {
            sink.tableHeaderCell(attribs);
        } else if (parser.getName().equals(HtmlMarkup.TD.toString())) {
            sink.tableCell(attribs);
        } else if (parser.getName().equals(HtmlMarkup.CAPTION.toString())) {
            sink.tableCaption(attribs);
        } else if (parser.getName().equals(HtmlMarkup.BR.toString())) {
            sink.lineBreak(attribs);
        } else if (parser.getName().equals(HtmlMarkup.WBR.toString())) {
            sink.lineBreakOpportunity(attribs);
        } else if (parser.getName().equals(HtmlMarkup.HR.toString())) {
            sink.horizontalRule(attribs);
        } else if (parser.getName().equals(HtmlMarkup.IMG.toString())) {
            this.handleImgStart(parser, sink, attribs);
        } else if (parser.getName().equals(HtmlMarkup.SCRIPT.toString()) || parser.getName().equals(HtmlMarkup.STYLE.toString())) {
            this.handleUnknown(parser, sink, 2);
            this.scriptBlock = true;
        } else {
            visited = false;
        }
        return visited;
    }

    protected boolean baseEndTag(XmlPullParser parser, Sink sink) {
        boolean visited = true;
        if (parser.getName().equals(HtmlMarkup.P.toString())) {
            sink.paragraph_();
        } else if (parser.getName().equals(HtmlMarkup.DIV.toString())) {
            this.handleDivEnd(sink);
        } else if (parser.getName().equals(HtmlMarkup.PRE.toString())) {
            this.verbatim_();
            sink.verbatim_();
        } else if (parser.getName().equals(HtmlMarkup.UL.toString())) {
            sink.list_();
        } else if (parser.getName().equals(HtmlMarkup.OL.toString())) {
            sink.numberedList_();
            --this.orderedListDepth;
        } else if (parser.getName().equals(HtmlMarkup.LI.toString())) {
            this.handleListItemEnd(sink);
        } else if (parser.getName().equals(HtmlMarkup.DL.toString())) {
            if (this.hasDefinitionListItem) {
                sink.definitionListItem_();
                this.hasDefinitionListItem = false;
            }
            sink.definitionList_();
        } else if (parser.getName().equals(HtmlMarkup.DT.toString())) {
            sink.definedTerm_();
        } else if (parser.getName().equals(HtmlMarkup.DD.toString())) {
            sink.definition_();
            sink.definitionListItem_();
            this.hasDefinitionListItem = false;
        } else if (parser.getName().equals(HtmlMarkup.FIGURE.toString())) {
            sink.figure_();
        } else if (parser.getName().equals(HtmlMarkup.FIGCAPTION.toString())) {
            sink.figureCaption_();
        } else if (parser.getName().equals(HtmlMarkup.A.toString())) {
            this.handleAEnd(sink);
        } else if (parser.getName().equals(HtmlMarkup.EM.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.STRONG.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.SMALL.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.S.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.CITE.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.Q.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.DFN.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.ABBR.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.I.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.B.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.CODE.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.VAR.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.SAMP.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.KBD.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.SUP.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.SUB.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.U.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.MARK.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.RUBY.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.RB.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.RT.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.RTC.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.RP.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.BDI.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.BDO.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.SPAN.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.INS.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.DEL.toString())) {
            sink.inline_();
        } else if (parser.getName().equals(HtmlMarkup.TABLE.toString())) {
            sink.tableRows_();
            sink.table_();
        } else if (parser.getName().equals(HtmlMarkup.TR.toString())) {
            sink.tableRow_();
        } else if (parser.getName().equals(HtmlMarkup.TH.toString())) {
            sink.tableHeaderCell_();
        } else if (parser.getName().equals(HtmlMarkup.TD.toString())) {
            sink.tableCell_();
        } else if (parser.getName().equals(HtmlMarkup.CAPTION.toString())) {
            sink.tableCaption_();
        } else if (parser.getName().equals(HtmlMarkup.ARTICLE.toString())) {
            sink.article_();
        } else if (parser.getName().equals(HtmlMarkup.NAV.toString())) {
            sink.navigation_();
        } else if (parser.getName().equals(HtmlMarkup.ASIDE.toString())) {
            sink.sidebar_();
        } else if (parser.getName().equals(HtmlMarkup.SECTION.toString())) {
            this.handleSectionEnd(sink);
        } else if (parser.getName().equals(HtmlMarkup.H2.toString())) {
            sink.sectionTitle1_();
        } else if (parser.getName().equals(HtmlMarkup.H3.toString())) {
            sink.sectionTitle2_();
        } else if (parser.getName().equals(HtmlMarkup.H4.toString())) {
            sink.sectionTitle3_();
        } else if (parser.getName().equals(HtmlMarkup.H5.toString())) {
            sink.sectionTitle4_();
        } else if (parser.getName().equals(HtmlMarkup.H6.toString())) {
            sink.sectionTitle5_();
        } else if (parser.getName().equals(HtmlMarkup.HEADER.toString())) {
            sink.header_();
        } else if (parser.getName().equals(HtmlMarkup.MAIN.toString())) {
            sink.content_();
        } else if (parser.getName().equals(HtmlMarkup.FOOTER.toString())) {
            sink.footer_();
        } else if (parser.getName().equals(HtmlMarkup.SCRIPT.toString()) || parser.getName().equals(HtmlMarkup.STYLE.toString())) {
            this.handleUnknown(parser, sink, 3);
            this.scriptBlock = false;
        } else {
            visited = false;
        }
        return visited;
    }

    @Override
    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (!this.baseStartTag(parser, sink) && this.getLog().isWarnEnabled()) {
            String position = "[" + parser.getLineNumber() + ":" + parser.getColumnNumber() + "]";
            String tag = "<" + parser.getName() + ">";
            this.getLog().warn("Unrecognized xml tag: " + tag + " at " + position);
        }
    }

    @Override
    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (!this.baseEndTag(parser, sink)) {
            // empty if block
        }
    }

    @Override
    protected void handleText(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if (StringUtils.isNotEmpty(text) && !this.isScriptBlock()) {
            sink.text(text);
        }
    }

    @Override
    protected void handleComment(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if ("PB".equals(text.trim())) {
            sink.pageBreak();
        } else if (this.isEmitComments()) {
            sink.comment(text);
        }
    }

    @Override
    protected void handleCdsect(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if (this.isScriptBlock()) {
            sink.unknown("CDATA", new Object[]{5, text}, null);
        } else {
            sink.text(text);
        }
    }

    protected void consecutiveSections(int newLevel, Sink sink, SinkEventAttributeSet attribs) {
        this.closeOpenSections(newLevel, sink);
        this.openMissingSections(newLevel, sink);
        this.headingLevel = newLevel;
    }

    private void closeOpenSections(int newLevel, Sink sink) {
        while (this.headingLevel >= newLevel && this.sectionLevel < this.headingLevel) {
            if (this.headingLevel == 5) {
                sink.section5_();
            } else if (this.headingLevel == 4) {
                sink.section4_();
            } else if (this.headingLevel == 3) {
                sink.section3_();
            } else if (this.headingLevel == 2) {
                sink.section2_();
            } else if (this.headingLevel == 1) {
                sink.section1_();
            }
            --this.headingLevel;
        }
    }

    private void openMissingSections(int newLevel, Sink sink) {
        while (this.headingLevel < newLevel && this.sectionLevel < newLevel) {
            ++this.headingLevel;
            if (this.headingLevel == 5) {
                sink.section5();
                continue;
            }
            if (this.headingLevel == 4) {
                sink.section4();
                continue;
            }
            if (this.headingLevel == 3) {
                sink.section3();
                continue;
            }
            if (this.headingLevel == 2) {
                sink.section2();
                continue;
            }
            if (this.headingLevel != 1) continue;
            sink.section1();
        }
    }

    protected int getSectionLevel() {
        return this.headingLevel;
    }

    protected void setSectionLevel(int newLevel) {
        this.headingLevel = newLevel;
    }

    protected void verbatim_() {
        this.inVerbatim = false;
    }

    protected void verbatim() {
        this.inVerbatim = true;
    }

    protected boolean isVerbatim() {
        return this.inVerbatim;
    }

    protected boolean isScriptBlock() {
        return this.scriptBlock;
    }

    protected String validAnchor(String id) {
        if (!DoxiaUtils.isValidId(id)) {
            String linkAnchor = DoxiaUtils.encodeId(id, true);
            String msg = "Modified invalid link: '" + id + "' to '" + linkAnchor + "'";
            this.logMessage("modifiedLink", msg);
            return linkAnchor;
        }
        return id;
    }

    @Override
    protected void init() {
        super.init();
        this.scriptBlock = false;
        this.isLink = false;
        this.isAnchor = false;
        this.orderedListDepth = 0;
        this.headingLevel = 0;
        this.inVerbatim = false;
        this.warnMessages = null;
    }

    private void handleAEnd(Sink sink) {
        if (this.isLink) {
            sink.link_();
            this.isLink = false;
        } else if (this.isAnchor) {
            sink.anchor_();
            this.isAnchor = false;
        }
    }

    private void handleAStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) {
        String href = parser.getAttributeValue(null, HTML.Attribute.HREF.toString());
        if (href != null) {
            String hash;
            int hashIndex = href.indexOf(35);
            if (hashIndex != -1 && !DoxiaUtils.isExternalLink(href) && !DoxiaUtils.isValidId(hash = href.substring(hashIndex + 1))) {
                href = href.substring(0, hashIndex) + "#" + DoxiaUtils.encodeId(hash, true);
                String msg = "Modified invalid link: '" + hash + "' to '" + href + "'";
                this.logMessage("modifiedLink", msg);
            }
            sink.link(href, attribs);
            this.isLink = true;
        } else {
            String name = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
            if (name != null) {
                sink.anchor(this.validAnchor(name), attribs);
                this.isAnchor = true;
            } else {
                String id = parser.getAttributeValue(null, HTML.Attribute.ID.toString());
                if (id != null) {
                    sink.anchor(this.validAnchor(id), attribs);
                    this.isAnchor = true;
                }
            }
        }
    }

    private boolean handleDivStart(XmlPullParser parser, SinkEventAttributeSet attribs, Sink sink) {
        String divclass = parser.getAttributeValue(null, HTML.Attribute.CLASS.toString());
        this.divStack.push(divclass);
        if ("content".equals(divclass)) {
            SinkEventAttributeSet atts = new SinkEventAttributeSet(attribs);
            atts.removeAttribute("class");
            sink.content(atts);
        }
        if ("source".equals(divclass)) {
            return false;
        }
        sink.division(attribs);
        return true;
    }

    private boolean handleDivEnd(Sink sink) {
        String divclass = this.divStack.pop();
        if ("content".equals(divclass)) {
            sink.content_();
        }
        if ("source".equals(divclass)) {
            return false;
        }
        sink.division_();
        return true;
    }

    private void handleImgStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) {
        String src = parser.getAttributeValue(null, HTML.Attribute.SRC.toString());
        if (src != null) {
            sink.figureGraphics(src, attribs);
        }
    }

    private void handleLIStart(Sink sink, SinkEventAttributeSet attribs) {
        if (this.orderedListDepth == 0) {
            sink.listItem(attribs);
        } else {
            sink.numberedListItem(attribs);
        }
    }

    private void handleListItemEnd(Sink sink) {
        if (this.orderedListDepth == 0) {
            sink.listItem_();
        } else {
            sink.numberedListItem_();
        }
    }

    private void handleOLStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) {
        int numbering = 0;
        String style = parser.getAttributeValue(null, HTML.Attribute.STYLE.toString());
        if (style != null) {
            switch (style) {
                case "list-style-type: upper-alpha": {
                    numbering = 2;
                    break;
                }
                case "list-style-type: lower-alpha": {
                    numbering = 1;
                    break;
                }
                case "list-style-type: upper-roman": {
                    numbering = 4;
                    break;
                }
                case "list-style-type: lower-roman": {
                    numbering = 3;
                    break;
                }
                case "list-style-type: decimal": {
                    numbering = 0;
                    break;
                }
            }
        }
        sink.numberedList(numbering, attribs);
        ++this.orderedListDepth;
    }

    private void handlePStart(Sink sink, SinkEventAttributeSet attribs) {
        sink.paragraph(attribs);
    }

    private void handlePreStart(SinkEventAttributeSet attribs, Sink sink) {
        this.verbatim();
        sink.verbatim(attribs);
    }

    private void handleSectionStart(Sink sink, SinkEventAttributeSet attribs) {
        sink.section(++this.sectionLevel, attribs);
    }

    private void handleHeadingStart(Sink sink, int level, SinkEventAttributeSet attribs) {
        this.consecutiveSections(level, sink, attribs);
        sink.sectionTitle(level, attribs);
    }

    private void handleSectionEnd(Sink sink) {
        this.closeOpenSections(this.sectionLevel, sink);
        this.headingLevel = 0;
        sink.section_(this.sectionLevel--);
    }

    private void handleTableStart(Sink sink, SinkEventAttributeSet attribs, XmlPullParser parser) {
        sink.table(attribs);
        String border = parser.getAttributeValue(null, HTML.Attribute.BORDER.toString());
        boolean grid = true;
        if (border == null || "0".equals(border)) {
            grid = false;
        }
        String align = parser.getAttributeValue(null, HTML.Attribute.ALIGN.toString());
        int[] justif = new int[]{1};
        if ("center".equals(align)) {
            justif[0] = 0;
        } else if ("right".equals(align)) {
            justif[0] = 2;
        }
        sink.tableRows(justif, grid);
    }

    private void logMessage(String key, String msg) {
        Set<String> set;
        String log = "[XHTML Parser] " + msg;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(log);
            return;
        }
        if (this.warnMessages == null) {
            this.warnMessages = new HashMap<String, Set<String>>();
        }
        if ((set = this.warnMessages.get(key)) == null) {
            set = new TreeSet<String>();
        }
        set.add(log);
        this.warnMessages.put(key, set);
    }

    private void logWarnings() {
        if (this.getLog().isWarnEnabled() && this.warnMessages != null && !this.isSecondParsing()) {
            for (Map.Entry<String, Set<String>> entry : this.warnMessages.entrySet()) {
                for (String msg : entry.getValue()) {
                    this.getLog().warn(msg);
                }
            }
            this.warnMessages = null;
        }
    }
}

